/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.ConcurrentBarrier;
import org.apache.tapestry5.ioc.internal.util.MessageFormatterImpl;

public abstract class AbstractMessages
implements Messages {
    private final ConcurrentBarrier barrier = new ConcurrentBarrier();
    private final Map<String, MessageFormatter> cache = CollectionFactory.newCaseInsensitiveMap();
    private final Locale locale;

    protected AbstractMessages(Locale locale) {
        this.locale = locale;
    }

    protected abstract String valueForKey(String var1);

    public boolean contains(String key) {
        return this.valueForKey(key) != null;
    }

    public String get(String key) {
        if (this.contains(key)) {
            return this.valueForKey(key);
        }
        return String.format("[[missing key: %s]]", key);
    }

    public MessageFormatter getFormatter(final String key) {
        MessageFormatter result = this.barrier.withRead(new Invokable<MessageFormatter>(){

            @Override
            public MessageFormatter invoke() {
                return (MessageFormatter)AbstractMessages.this.cache.get(key);
            }
        });
        if (result != null) {
            return result;
        }
        final MessageFormatter newFormatter = this.buildMessageFormatter(key);
        this.barrier.withWrite(new Runnable(){

            public void run() {
                AbstractMessages.this.cache.put(key, newFormatter);
            }
        });
        return newFormatter;
    }

    private MessageFormatter buildMessageFormatter(String key) {
        String format = this.get(key);
        return new MessageFormatterImpl(format, this.locale);
    }

    public String format(String key, Object ... args) {
        return this.getFormatter(key).format(args);
    }
}

