/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Constructor;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyShadowBuilder;
import org.apache.tapestry5.ioc.util.BodyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyShadowBuilderImpl
implements PropertyShadowBuilder {
    private final ClassFactory classFactory;
    private final PropertyAccess propertyAccess;

    public PropertyShadowBuilderImpl(@Builtin ClassFactory classFactory, PropertyAccess propertyAccess) {
        this.classFactory = classFactory;
        this.propertyAccess = propertyAccess;
    }

    @Override
    public <T> T build(Object source, String propertyName, Class<T> propertyType) {
        Class<?> sourceClass = source.getClass();
        PropertyAdapter adapter = this.propertyAccess.getAdapter(sourceClass).getPropertyAdapter(propertyName);
        if (adapter == null) {
            throw new RuntimeException(ServiceMessages.noSuchProperty(sourceClass, propertyName));
        }
        if (!adapter.isRead()) {
            throw new RuntimeException(ServiceMessages.readNotSupported(source, propertyName));
        }
        if (!propertyType.isAssignableFrom(adapter.getType())) {
            throw new RuntimeException(ServiceMessages.propertyTypeMismatch(propertyName, sourceClass, adapter.getType(), propertyType));
        }
        ClassFab cf = this.classFactory.newClass(propertyType);
        cf.addField("_source", 18, sourceClass);
        cf.addConstructor(new Class[]{sourceClass}, null, "_source = $1;");
        BodyBuilder body = new BodyBuilder();
        body.begin();
        body.addln("%s result = _source.%s();", sourceClass.getName(), adapter.getReadMethod().getName());
        body.addln("if (result == null)", new Object[0]);
        body.begin();
        body.addln("throw new NullPointerException(%s.buildMessage(_source, \"%s\"));", this.getClass().getName(), propertyName);
        body.end();
        body.addln("return result;", new Object[0]);
        body.end();
        MethodSignature sig = new MethodSignature(propertyType, "_delegate", null, null);
        cf.addMethod(2, sig, body.toString());
        String toString = String.format("<Shadow: property %s of %s>", propertyName, source);
        cf.proxyMethodsToDelegate(propertyType, "_delegate()", toString);
        Class shadowClass = cf.createClass();
        try {
            Constructor<?> cc = shadowClass.getConstructors()[0];
            Object instance = cc.newInstance(source);
            return propertyType.cast(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final String buildMessage(Object source, String propertyName) {
        return String.format("Unable to delegate method invocation to property '%s' of %s, because the property is null.", propertyName, source);
    }
}

