/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.ioc.internal.services.AbstractInvocation;
import org.apache.tapestry5.ioc.internal.services.ConstantInjector;
import org.apache.tapestry5.ioc.internal.services.MethodInfo;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.apache.tapestry5.ioc.util.BodyBuilder;

public class AdvisedMethodInvocationBuilder {
    private static final String PARAMETER_FIELD = "p";
    private static final String DELEGATE_FIELD_NAME = "delegate";
    private static final int PRIVATE_FINAL = 18;
    private static final MethodSignature GET_PARAMETER_SIGNATURE = new MethodSignature(Object.class, "getParameter", new Class[]{Integer.TYPE}, null);
    private static final MethodSignature OVERRIDE_SIGNATURE = new MethodSignature(Void.TYPE, "override", new Class[]{Integer.TYPE, Object.class}, null);
    private static final MethodSignature INVOKE_DELEGATE_METHOD_SIGNATURE = new MethodSignature(Void.TYPE, "invokeDelegateMethod", null, null);
    private static final AtomicLong UID_GENERATOR = new AtomicLong(System.currentTimeMillis());
    private final Class serviceInterface;
    private final Method method;
    private final MethodInfo info;
    private final ClassFab classFab;

    public AdvisedMethodInvocationBuilder(ClassFactory classFactory, Class serviceInterface, Method method) {
        this.serviceInterface = serviceInterface;
        this.method = method;
        this.info = new MethodInfo(method);
        String name = "Invocation$" + serviceInterface.getSimpleName() + "$" + method.getName() + "$" + Long.toHexString(UID_GENERATOR.getAndIncrement());
        this.classFab = classFactory.newClass(name, AbstractInvocation.class);
        this.addInfrastructure();
        this.addGetParameter();
        this.addOverride();
        this.addInvokeDelegateMethod();
        this.classFab.addToString(String.format("<Method invocation %s>", method));
    }

    private void addInfrastructure() {
        List<Class> constructorTypes = CollectionFactory.newList();
        constructorTypes.add(MethodInfo.class);
        BodyBuilder constructorBuilder = new BodyBuilder().begin().addln("super($1);", new Object[0]);
        this.classFab.addField(DELEGATE_FIELD_NAME, 18, this.serviceInterface);
        constructorTypes.add(this.serviceInterface);
        constructorBuilder.addln("%s = $2;", DELEGATE_FIELD_NAME);
        for (int i = 0; i < this.method.getParameterTypes().length; ++i) {
            Class<?> type = this.method.getParameterTypes()[i];
            String name = PARAMETER_FIELD + i;
            this.classFab.addField(name, type);
            constructorTypes.add(type);
            constructorBuilder.addln("%s = $%d;", name, i + 3);
        }
        constructorBuilder.end();
        Class[] typesArray = constructorTypes.toArray(new Class[constructorTypes.size()]);
        this.classFab.addConstructor(typesArray, null, constructorBuilder.toString());
    }

    private void addGetParameter() {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        BodyBuilder builder = new BodyBuilder().begin();
        builder.addln("switch ($1)", new Object[0]).begin();
        for (int i = 0; i < parameterTypes.length; ++i) {
            builder.addln("case %d: return ($w) %s%d;", i, PARAMETER_FIELD, i);
        }
        builder.addln("default: throw new IllegalArgumentException(\"Parameter index out of range.\");", new Object[0]);
        builder.end().end();
        this.classFab.addMethod(1, GET_PARAMETER_SIGNATURE, builder.toString());
    }

    private void addOverride() {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        BodyBuilder builder = new BodyBuilder().begin();
        builder.addln("switch ($1)", new Object[0]).begin();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> type = parameterTypes[i];
            String typeName = ClassFabUtils.toJavaClassName(type);
            builder.addln("case %d: %s%d = %s; return;", i, PARAMETER_FIELD, i, ClassFabUtils.castReference("$2", typeName));
        }
        builder.addln("default: throw new IllegalArgumentException(\"Parameter index out of range.\");", new Object[0]);
        builder.end().end();
        this.classFab.addMethod(1, OVERRIDE_SIGNATURE, builder.toString());
    }

    private void addInvokeDelegateMethod() {
        Class<?> returnType = this.method.getReturnType();
        Class<?>[] exceptionTypes = this.method.getExceptionTypes();
        boolean isNonVoid = !returnType.equals(Void.TYPE);
        boolean hasChecked = exceptionTypes.length > 0;
        BodyBuilder builder = new BodyBuilder().begin();
        if (hasChecked) {
            builder.addln("try", new Object[0]).begin();
        }
        if (isNonVoid) {
            builder.add("%s result = ", ClassFabUtils.toJavaClassName(returnType));
        }
        builder.add("%s.%s(", DELEGATE_FIELD_NAME, this.method.getName());
        for (int i = 0; i < this.method.getParameterTypes().length; ++i) {
            if (i > 0) {
                builder.add(", ", new Object[0]);
            }
            builder.add(PARAMETER_FIELD + i, new Object[0]);
        }
        builder.addln(");", new Object[0]);
        if (isNonVoid) {
            builder.add("overrideResult(($w) result);", new Object[0]);
        }
        if (hasChecked) {
            builder.end();
            for (Class<?> exception : exceptionTypes) {
                builder.addln("catch (%s ex) { overrideThrown(ex); }", exception.getName());
            }
        }
        builder.end();
        this.classFab.addMethod(1, INVOKE_DELEGATE_METHOD_SIGNATURE, builder.toString());
    }

    public void addAdvice(MethodAdvice advice) {
        this.info.addAdvice(advice);
    }

    public void commit(ClassFab interceptorClassFab, String delegateFieldName, ConstantInjector injector) {
        Class invocationClass = this.classFab.createClass();
        BodyBuilder builder = new BodyBuilder().begin();
        builder.addln("%s invocation = new %<s(%s, %s, $$);", invocationClass.getName(), injector.inject(MethodInfo.class, this.info), delegateFieldName);
        builder.addln("invocation.proceed();", new Object[0]);
        Class<?>[] exceptionTypes = this.method.getExceptionTypes();
        builder.addln("if (invocation.isFail())", new Object[0]).begin();
        for (Class<?> exceptionType : exceptionTypes) {
            String name = exceptionType.getSimpleName().toLowerCase();
            String exceptionTypeFieldName = injector.inject(Class.class, exceptionType);
            builder.addln("%s %s = (%s) invocation.getThrown(%s);", exceptionType.getName(), name, exceptionType.getName(), exceptionTypeFieldName);
            builder.addln("if (%s != null) throw %s;", name, name);
        }
        builder.addln("throw new IllegalStateException(\"Impossible exception thrown from intercepted invocation.\");", new Object[0]);
        builder.end();
        builder.addln("return ($r) invocation.getResult();", new Object[0]);
        builder.end();
        interceptorClassFab.addMethod(1, new MethodSignature(this.method), builder.toString());
    }
}

