/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodIterator;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.apache.tapestry5.ioc.services.ThunkCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThunkCreatorImpl
implements ThunkCreator {
    private final Map<Class, Class> interfaceToThunkClass = CollectionFactory.newConcurrentMap();
    private final ClassFactory classFactory;
    private final MethodSignature toStringSignature = new MethodSignature(String.class, "toString", null, null);
    private static final int PRIVATE_FINAL = 18;
    private static final String DESCRIPTION_FIELD = "_$description";
    private static final String CREATOR_FIELD = "_$creator";
    private static final String DELEGATE_METHOD = "_$delegate";

    public ThunkCreatorImpl(@Builtin ClassFactory classFactory) {
        this.classFactory = classFactory;
    }

    @Override
    public <T> T createThunk(Class<T> proxyType, ObjectCreator objectCreator, String description) {
        Throwable failure;
        assert (proxyType != null);
        assert (objectCreator != null);
        assert (InternalUtils.isNonBlank(description));
        if (!proxyType.isInterface()) {
            throw new IllegalArgumentException(String.format("Thunks may only be created for interfaces; %s is a class.", ClassFabUtils.toJavaClassName(proxyType)));
        }
        Class thunkClass = this.getThunkClass(proxyType);
        try {
            return proxyType.cast(thunkClass.getConstructors()[0].newInstance(description, objectCreator));
        }
        catch (InvocationTargetException ex) {
            failure = ex.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        throw new RuntimeException(String.format("Exception instantiating thunk class %s: %s", thunkClass.getName(), InternalUtils.toMessage(failure)), failure);
    }

    private Class getThunkClass(Class type) {
        Class result = this.interfaceToThunkClass.get(type);
        if (result == null) {
            result = this.constructThunkClass(type);
            this.interfaceToThunkClass.put(type, result);
        }
        return result;
    }

    private Class constructThunkClass(Class interfaceType) {
        ClassFab classFab = this.classFactory.newClass(interfaceType);
        classFab.addField(DESCRIPTION_FIELD, 18, String.class);
        classFab.addField(CREATOR_FIELD, 18, ObjectCreator.class);
        classFab.addConstructor(new Class[]{String.class, ObjectCreator.class}, null, String.format("{ %s = $1; %s = $2; }", DESCRIPTION_FIELD, CREATOR_FIELD));
        MethodSignature sig = new MethodSignature(interfaceType, DELEGATE_METHOD, null, null);
        classFab.addMethod(2, sig, String.format("return ($r) %s.createObject();", CREATOR_FIELD));
        MethodIterator mi = new MethodIterator(interfaceType);
        while (mi.hasNext()) {
            sig = mi.next();
            classFab.addMethod(1, sig, String.format("return ($r) %s().%s($$);", DELEGATE_METHOD, sig.getName()));
        }
        if (!mi.getToString()) {
            classFab.addMethod(1, this.toStringSignature, String.format("return %s;", DESCRIPTION_FIELD));
        }
        return classFab.createClass();
    }
}

