/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Map;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.internal.AbstractConfigurationImpl;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.OrderedConfigurationOverride;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.Orderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingOrderedConfigurationWrapper<T>
extends AbstractConfigurationImpl<T>
implements OrderedConfiguration<T> {
    private final Orderer<T> orderer;
    private final String serviceId;
    private final Class<T> expectedType;
    private final Map<String, OrderedConfigurationOverride<T>> overrides;
    private final ContributionDef contribDef;

    public ValidatingOrderedConfigurationWrapper(Class<T> expectedType, ObjectLocator locator, Orderer<T> orderer, Map<String, OrderedConfigurationOverride<T>> overrides, ContributionDef contribDef, String serviceId) {
        super(expectedType, locator);
        this.orderer = orderer;
        this.overrides = overrides;
        this.contribDef = contribDef;
        this.serviceId = serviceId;
        this.expectedType = expectedType;
    }

    @Override
    public void add(String id, T object, String ... constraints) {
        this.checkValid(object);
        this.orderer.add(id, object, constraints);
    }

    @Override
    public void override(String id, T object, String ... constraints) {
        assert (InternalUtils.isNonBlank(id));
        this.checkValid(object);
        OrderedConfigurationOverride<T> existing = this.overrides.get(id);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Contribution '%s' has already been overridden (by %s).", id, existing.getContribDef()));
        }
        this.overrides.put(id, new OrderedConfigurationOverride<T>(this.orderer, id, object, constraints, this.contribDef));
    }

    @Override
    public void addInstance(String id, Class<? extends T> clazz, String ... constraints) {
        this.add(id, this.instantiate(clazz), constraints);
    }

    @Override
    public void overrideInstance(String id, Class<? extends T> clazz, String ... constraints) {
        this.override(id, this.instantiate(clazz), constraints);
    }

    private void checkValid(T object) {
        if (object == null || this.expectedType.isInstance(object)) {
            return;
        }
        throw new IllegalArgumentException(IOCMessages.contributionWrongValueType(this.serviceId, object.getClass(), this.expectedType));
    }
}

