/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.slf4j.Logger;

public class AbstractMethodInvokingInstrumenter {
    private final ModuleBuilderSource moduleSource;
    protected final Map<Class, Object> resourcesDefaults = CollectionFactory.newMap();
    private final ServiceResources resources;
    private final ClassFactory classFactory;
    protected final Method method;
    protected final Class serviceInterface;
    protected final String serviceId;
    private final Logger logger;

    public AbstractMethodInvokingInstrumenter(ModuleBuilderSource moduleSource, Method method, ServiceResources resources, ClassFactory classFactory) {
        this.moduleSource = moduleSource;
        this.method = method;
        this.resources = resources;
        this.classFactory = classFactory;
        this.serviceId = resources.getServiceId();
        this.resourcesDefaults.put(String.class, this.serviceId);
        this.resourcesDefaults.put(ObjectLocator.class, resources);
        this.resourcesDefaults.put(ServiceResources.class, resources);
        this.logger = resources.getLogger();
        this.resourcesDefaults.put(Logger.class, this.logger);
        this.serviceInterface = resources.getServiceInterface();
        this.resourcesDefaults.put(Class.class, this.serviceInterface);
        this.resourcesDefaults.put(OperationTracker.class, resources.getTracker());
    }

    public String toString() {
        return this.classFactory.getMethodLocation(this.method).toString();
    }

    private Object getModuleInstance() {
        return InternalUtils.isStatic(this.method) ? null : this.moduleSource.getModuleBuilder();
    }

    protected Object invoke(InjectionResources injectionResources) {
        Object result = null;
        Throwable failure = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Invoking method %s", this));
        }
        try {
            Object[] parameters = InternalUtils.calculateParametersForMethod(this.method, this.resources, injectionResources, this.resources.getTracker());
            result = this.method.invoke(this.getModuleInstance(), parameters);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        if (failure != null) {
            throw new RuntimeException(String.format("Exception invoking method %s: %s", this, InternalUtils.toMessage(failure)), failure);
        }
        return result;
    }
}

