// Copyright 2006 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.ioc.services.SymbolProvider;

/**
 * Obtains symbol values from JVM System properties. This implementation is usually ordered first, so that explicit
 * overrides, provided as JVM system properties, can take effect.
 */
public class SystemPropertiesSymbolProvider implements SymbolProvider
{
    public String valueForSymbol(String symbolName)
    {
        return System.getProperty(symbolName);
    }
}
