/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.test;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.test.MockTester;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.easymock.IMocksControl;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBase
extends Assert {
    private final MockTester tester = new MockTester();

    protected final IMocksControl getMocksControl() {
        return this.tester.getMocksControl();
    }

    @AfterMethod(alwaysRun=true)
    public final void discardMockControl() {
        this.tester.cleanup();
    }

    protected final <T> T newMock(Class<T> mockClass) {
        return this.tester.newMock(mockClass);
    }

    protected final void replay() {
        this.tester.replay();
    }

    protected final void verify() {
        this.tester.verify();
    }

    protected static void setThrowable(Throwable throwable) {
        EasyMock.expectLastCall().andThrow(throwable);
    }

    protected static void setAnswer(IAnswer answer) {
        EasyMock.expectLastCall().andAnswer(answer);
    }

    protected static void unreachable() {
        TestBase.fail((String)"This code should not be reachable.");
    }

    protected static <T> IExpectationSetters<T> expect(T value) {
        return EasyMock.expect(value);
    }

    protected static void assertMessageContains(Throwable t, String ... substrings) {
        String message = t.getMessage();
        for (String substring : substrings) {
            TestBase.assertTrue((boolean)message.contains(substring), (String)String.format("String '%s' not found in '%s'.", substring, message));
        }
    }

    protected static <T> void assertListsEquals(List<T> actual, List<T> expected) {
        int count = Math.min(actual.size(), expected.size());
        for (int i = 0; i < count; ++i) {
            TestBase.assertEquals(actual.get(i), expected.get(i), (String)String.format("Element #%d.", i));
        }
        TestBase.assertEquals((int)actual.size(), (int)expected.size(), (String)"List size.");
    }

    protected static <T> void assertListsEquals(List<T> actual, T ... expected) {
        TestBase.assertListsEquals(actual, Arrays.asList(expected));
    }

    protected static <T> void assertArraysEqual(T[] actual, T ... expected) {
        TestBase.assertListsEquals(Arrays.asList(actual), expected);
    }

    protected static <T> Capture<T> newCapture() {
        return new Capture();
    }

    protected static <T> T create(Class<T> objectType, Object ... fieldValues) {
        T result = null;
        try {
            result = objectType.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to instantiate instance of %s: %s", objectType.getName(), InternalUtils.toMessage(ex)), ex);
        }
        return TestBase.set(result, fieldValues);
    }

    protected static <T> T set(T object, Object ... fieldValues) {
        Defense.notNull(object, "object");
        Class<?> objectClass = object.getClass();
        for (int i = 0; i < fieldValues.length; i += 2) {
            String fieldName = (String)fieldValues[i];
            Object fieldValue = fieldValues[i + 1];
            try {
                Field field = TestBase.findField(objectClass, fieldName);
                field.setAccessible(true);
                field.set(object, fieldValue);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Unable to set field '%s' of %s to %s: %s", fieldName, object, fieldValue, InternalUtils.toMessage(ex)), ex);
            }
        }
        return object;
    }

    protected static Object get(Object object, String fieldName) {
        Defense.notNull(object, "object");
        Defense.notBlank(fieldName, "fieldName");
        try {
            Field field = TestBase.findField(object.getClass(), fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to read field '%s' of %s: %s", fieldName, object, InternalUtils.toMessage(ex)), ex);
        }
    }

    private static Field findField(Class objectClass, String fieldName) {
        for (Class cursor = objectClass; cursor != null; cursor = cursor.getSuperclass()) {
            try {
                return cursor.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new RuntimeException(String.format("Class %s does not contain a field named '%s'.", objectClass.getName(), fieldName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalControl
    extends ThreadLocal<IMocksControl> {
        private ThreadLocalControl() {
        }

        @Override
        protected IMocksControl initialValue() {
            return EasyMock.createControl();
        }
    }
}

