/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.services;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.ServiceLifecycle2;
import org.apache.tapestry5.ioc.annotations.IntermediateType;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.PreventServiceDecoration;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.services.AspectDecoratorImpl;
import org.apache.tapestry5.ioc.internal.services.AutobuildObjectProvider;
import org.apache.tapestry5.ioc.internal.services.ChainBuilderImpl;
import org.apache.tapestry5.ioc.internal.services.ClassNameLocatorImpl;
import org.apache.tapestry5.ioc.internal.services.ClasspathURLConverterImpl;
import org.apache.tapestry5.ioc.internal.services.DefaultImplementationBuilderImpl;
import org.apache.tapestry5.ioc.internal.services.ExceptionAnalyzerImpl;
import org.apache.tapestry5.ioc.internal.services.ExceptionTrackerImpl;
import org.apache.tapestry5.ioc.internal.services.LazyAdvisorImpl;
import org.apache.tapestry5.ioc.internal.services.LoggingAdvisorImpl;
import org.apache.tapestry5.ioc.internal.services.LoggingDecoratorImpl;
import org.apache.tapestry5.ioc.internal.services.MapSymbolProvider;
import org.apache.tapestry5.ioc.internal.services.MasterObjectProviderImpl;
import org.apache.tapestry5.ioc.internal.services.NonParallelExecutor;
import org.apache.tapestry5.ioc.internal.services.ParallelExecutorImpl;
import org.apache.tapestry5.ioc.internal.services.PerThreadServiceLifecycle;
import org.apache.tapestry5.ioc.internal.services.PipelineBuilderImpl;
import org.apache.tapestry5.ioc.internal.services.PropertyAccessImpl;
import org.apache.tapestry5.ioc.internal.services.PropertyShadowBuilderImpl;
import org.apache.tapestry5.ioc.internal.services.RegistryStartup;
import org.apache.tapestry5.ioc.internal.services.ServiceOverrideImpl;
import org.apache.tapestry5.ioc.internal.services.StrategyBuilderImpl;
import org.apache.tapestry5.ioc.internal.services.SymbolObjectProvider;
import org.apache.tapestry5.ioc.internal.services.SymbolSourceImpl;
import org.apache.tapestry5.ioc.internal.services.SystemPropertiesSymbolProvider;
import org.apache.tapestry5.ioc.internal.services.ThreadLocaleImpl;
import org.apache.tapestry5.ioc.internal.services.ThunkCreatorImpl;
import org.apache.tapestry5.ioc.internal.services.TypeCoercerImpl;
import org.apache.tapestry5.ioc.internal.services.ValueObjectProvider;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ApplicationDefaults;
import org.apache.tapestry5.ioc.services.AspectDecorator;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ChainBuilder;
import org.apache.tapestry5.ioc.services.ClassNameLocator;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.ioc.services.Coercion;
import org.apache.tapestry5.ioc.services.CoercionTuple;
import org.apache.tapestry5.ioc.services.DefaultImplementationBuilder;
import org.apache.tapestry5.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry5.ioc.services.ExceptionTracker;
import org.apache.tapestry5.ioc.services.FactoryDefaults;
import org.apache.tapestry5.ioc.services.LazyAdvisor;
import org.apache.tapestry5.ioc.services.LoggingAdvisor;
import org.apache.tapestry5.ioc.services.LoggingDecorator;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.ioc.services.ParallelExecutor;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.PipelineBuilder;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyShadowBuilder;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.ioc.services.ServiceLifecycleSource;
import org.apache.tapestry5.ioc.services.ServiceOverride;
import org.apache.tapestry5.ioc.services.StrategyBuilder;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.services.ThunkCreator;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.ioc.util.TimeInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Marker(value={Builtin.class})
@PreventServiceDecoration
public final class TapestryIOCModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(LoggingDecorator.class, LoggingDecoratorImpl.class);
        binder.bind(ChainBuilder.class, ChainBuilderImpl.class);
        binder.bind(PropertyAccess.class, PropertyAccessImpl.class);
        binder.bind(StrategyBuilder.class, StrategyBuilderImpl.class);
        binder.bind(PropertyShadowBuilder.class, PropertyShadowBuilderImpl.class);
        binder.bind(PipelineBuilder.class, PipelineBuilderImpl.class);
        binder.bind(DefaultImplementationBuilder.class, DefaultImplementationBuilderImpl.class);
        binder.bind(ExceptionTracker.class, ExceptionTrackerImpl.class);
        binder.bind(ExceptionAnalyzer.class, ExceptionAnalyzerImpl.class);
        binder.bind(TypeCoercer.class, TypeCoercerImpl.class);
        binder.bind(ThreadLocale.class, ThreadLocaleImpl.class);
        binder.bind(SymbolSource.class, SymbolSourceImpl.class);
        binder.bind(SymbolProvider.class, MapSymbolProvider.class).withId("ApplicationDefaults").withMarker(ApplicationDefaults.class);
        binder.bind(SymbolProvider.class, MapSymbolProvider.class).withId("FactoryDefaults").withMarker(FactoryDefaults.class);
        binder.bind(Runnable.class, RegistryStartup.class).withId("RegistryStartup");
        binder.bind(MasterObjectProvider.class, MasterObjectProviderImpl.class);
        binder.bind(ClassNameLocator.class, ClassNameLocatorImpl.class);
        binder.bind(AspectDecorator.class, AspectDecoratorImpl.class);
        binder.bind(ClasspathURLConverter.class, ClasspathURLConverterImpl.class);
        binder.bind(ServiceOverride.class, ServiceOverrideImpl.class);
        binder.bind(LoggingAdvisor.class, LoggingAdvisorImpl.class);
        binder.bind(LazyAdvisor.class, LazyAdvisorImpl.class);
        binder.bind(ThunkCreator.class, ThunkCreatorImpl.class);
    }

    public static ServiceLifecycleSource build(Map<String, ServiceLifecycle> configuration) {
        final Map<String, ServiceLifecycle2> lifecycles = CollectionFactory.newCaseInsensitiveMap();
        for (String name : configuration.keySet()) {
            lifecycles.put(name, InternalUtils.toServiceLifecycle2(configuration.get(name)));
        }
        return new ServiceLifecycleSource(){

            public ServiceLifecycle get(String scope) {
                return (ServiceLifecycle)lifecycles.get(scope);
            }
        };
    }

    public static void contributeServiceLifecycleSource(MappedConfiguration<String, ServiceLifecycle> configuration) {
        configuration.addInstance("perthread", PerThreadServiceLifecycle.class);
    }

    public static void contributeMasterObjectProvider(OrderedConfiguration<ObjectProvider> configuration, final @Local ServiceOverride serviceOverride) {
        configuration.add("AnnotationBasedContributions", null, new String[0]);
        configuration.addInstance("Value", ValueObjectProvider.class, "before:AnnotationBasedContributions");
        configuration.addInstance("Symbol", SymbolObjectProvider.class, "before:AnnotationBasedContributions");
        configuration.add("Autobuild", new AutobuildObjectProvider(), "before:AnnotationBasedContributions");
        ObjectProvider wrapper = new ObjectProvider(){

            @Override
            public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
                return serviceOverride.getServiceOverrideProvider().provide(objectType, annotationProvider, locator);
            }
        };
        configuration.add("ServiceOverride", wrapper, "after:AnnotationBasedContributions");
    }

    public static void contributeTypeCoercer(Configuration<CoercionTuple> configuration) {
        TapestryIOCModule.add(configuration, Object.class, String.class, new Coercion<Object, String>(){

            @Override
            public String coerce(Object input) {
                return input.toString();
            }
        });
        TapestryIOCModule.add(configuration, String.class, Double.class, new Coercion<String, Double>(){

            @Override
            public Double coerce(String input) {
                return new Double(input);
            }
        });
        TapestryIOCModule.add(configuration, String.class, BigDecimal.class, new Coercion<String, BigDecimal>(){

            @Override
            public BigDecimal coerce(String input) {
                return new BigDecimal(input);
            }
        });
        TapestryIOCModule.add(configuration, BigDecimal.class, Double.class, new Coercion<BigDecimal, Double>(){

            @Override
            public Double coerce(BigDecimal input) {
                return input.doubleValue();
            }
        });
        TapestryIOCModule.add(configuration, String.class, BigInteger.class, new Coercion<String, BigInteger>(){

            @Override
            public BigInteger coerce(String input) {
                return new BigInteger(input);
            }
        });
        TapestryIOCModule.add(configuration, String.class, Long.class, new Coercion<String, Long>(){

            @Override
            public Long coerce(String input) {
                return new Long(input);
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Byte.class, new Coercion<Long, Byte>(){

            @Override
            public Byte coerce(Long input) {
                return input.byteValue();
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Short.class, new Coercion<Long, Short>(){

            @Override
            public Short coerce(Long input) {
                return input.shortValue();
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Integer.class, new Coercion<Long, Integer>(){

            @Override
            public Integer coerce(Long input) {
                return input.intValue();
            }
        });
        TapestryIOCModule.add(configuration, Number.class, Long.class, new Coercion<Number, Long>(){

            @Override
            public Long coerce(Number input) {
                return input.longValue();
            }
        });
        TapestryIOCModule.add(configuration, Double.class, Float.class, new Coercion<Double, Float>(){

            @Override
            public Float coerce(Double input) {
                return Float.valueOf(input.floatValue());
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Double.class, new Coercion<Long, Double>(){

            @Override
            public Double coerce(Long input) {
                return input.doubleValue();
            }
        });
        TapestryIOCModule.add(configuration, String.class, Boolean.class, new Coercion<String, Boolean>(){

            @Override
            public Boolean coerce(String input) {
                String trimmed = input.trim();
                if (trimmed.equalsIgnoreCase("false") || trimmed.length() == 0) {
                    return false;
                }
                return true;
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Boolean.class, new Coercion<Long, Boolean>(){

            @Override
            public Boolean coerce(Long input) {
                return input != 0L;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, Boolean.class, new Coercion<Void, Boolean>(){

            @Override
            public Boolean coerce(Void input) {
                return false;
            }
        });
        TapestryIOCModule.add(configuration, Collection.class, Boolean.class, new Coercion<Collection, Boolean>(){

            @Override
            public Boolean coerce(Collection input) {
                return !input.isEmpty();
            }
        });
        TapestryIOCModule.add(configuration, Object.class, List.class, new Coercion<Object, List>(){

            @Override
            public List coerce(Object input) {
                return Collections.singletonList(input);
            }
        });
        TapestryIOCModule.add(configuration, Object[].class, List.class, new Coercion<Object[], List>(){

            @Override
            public List coerce(Object[] input) {
                return Arrays.asList(input);
            }
        });
        TapestryIOCModule.add(configuration, Float.class, Double.class, new Coercion<Float, Double>(){

            @Override
            public Double coerce(Float input) {
                return input.doubleValue();
            }
        });
        Coercion<Object, List> primitiveArrayCoercion = new Coercion<Object, List>(){

            @Override
            public List<Object> coerce(Object input) {
                int length = Array.getLength(input);
                Object[] array = new Object[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = Array.get(input, i);
                }
                return Arrays.asList(array);
            }
        };
        TapestryIOCModule.add(configuration, byte[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, short[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, int[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, long[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, float[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, double[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, char[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, boolean[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, String.class, File.class, new Coercion<String, File>(){

            @Override
            public File coerce(String input) {
                return new File(input);
            }
        });
        TapestryIOCModule.add(configuration, String.class, TimeInterval.class, new Coercion<String, TimeInterval>(){

            @Override
            public TimeInterval coerce(String input) {
                return new TimeInterval(input);
            }
        });
        TapestryIOCModule.add(configuration, TimeInterval.class, Long.class, new Coercion<TimeInterval, Long>(){

            @Override
            public Long coerce(TimeInterval input) {
                return input.milliseconds();
            }
        });
        TapestryIOCModule.add(configuration, Object.class, Object[].class, new Coercion<Object, Object[]>(){

            @Override
            public Object[] coerce(Object input) {
                return new Object[]{input};
            }
        });
        TapestryIOCModule.add(configuration, Collection.class, Object[].class, new Coercion<Collection, Object[]>(){

            @Override
            public Object[] coerce(Collection input) {
                return input.toArray();
            }
        });
    }

    private static <S, T> void add(Configuration<CoercionTuple> configuration, Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        CoercionTuple<S, T> tuple = new CoercionTuple<S, T>(sourceType, targetType, coercion);
        configuration.add(tuple);
    }

    public static void contributeSymbolSource(OrderedConfiguration<SymbolProvider> configuration, @ApplicationDefaults SymbolProvider applicationDefaults, @FactoryDefaults SymbolProvider factoryDefaults) {
        configuration.add("SystemProperties", new SystemPropertiesSymbolProvider(), "before:*");
        configuration.add("ApplicationDefaults", applicationDefaults, "after:SystemProperties");
        configuration.add("FactoryDefaults", factoryDefaults, "after:ApplicationDefaults");
    }

    public static ParallelExecutor buildDeferredExecution(@Symbol(value="tapestry.thread-pool.core-pool-size") int coreSize, @Symbol(value="tapestry.thread-pool.max-pool-size") int maxSize, @Symbol(value="tapestry.thread-pool.keep-alive") @IntermediateType(value=TimeInterval.class) int keepAliveMillis, @Symbol(value="tapestry.thread-pool-enabled") boolean threadPoolEnabled, PerthreadManager perthreadManager, RegistryShutdownHub shutdownHub, ThunkCreator thunkCreator) {
        if (!threadPoolEnabled) {
            return new NonParallelExecutor();
        }
        final ThreadPoolExecutor executorService = new ThreadPoolExecutor(coreSize, maxSize, keepAliveMillis, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxSize));
        shutdownHub.addRegistryShutdownListener(new RegistryShutdownListener(){

            public void registryDidShutdown() {
                executorService.shutdown();
            }
        });
        return new ParallelExecutorImpl(executorService, thunkCreator, perthreadManager);
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add("tapestry.thread-pool.core-pool-size", "3");
        configuration.add("tapestry.thread-pool.max-pool-size", "20");
        configuration.add("tapestry.thread-pool.keep-alive", "1 m");
        configuration.add("tapestry.thread-pool-enabled", "true");
    }
}

