/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.services;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFabUtils;

public class MethodSignature {
    private int hashCode = -1;
    private final Class returnType;
    private final String name;
    private final Class[] parameterTypes;
    private final Class[] exceptionTypes;

    public MethodSignature(Class returnType, String name, Class[] parameterTypes, Class[] exceptionTypes) {
        this.returnType = Defense.notNull(returnType, "returnType");
        this.name = Defense.notBlank(name, "name");
        this.parameterTypes = parameterTypes;
        this.exceptionTypes = exceptionTypes;
    }

    public MethodSignature(Method m) {
        this(m.getReturnType(), m.getName(), m.getParameterTypes(), m.getExceptionTypes());
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public String getName() {
        return this.name;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int i;
            this.hashCode = this.returnType.hashCode();
            this.hashCode = 31 * this.hashCode + this.name.hashCode();
            int count = InternalUtils.size(this.parameterTypes);
            for (i = 0; i < count; ++i) {
                this.hashCode = 31 * this.hashCode + this.parameterTypes[i].hashCode();
            }
            count = InternalUtils.size(this.exceptionTypes);
            for (i = 0; i < count; ++i) {
                this.hashCode = 31 * this.hashCode + this.exceptionTypes[i].hashCode();
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature ms = (MethodSignature)o;
        if (this.returnType != ms.returnType) {
            return false;
        }
        if (!this.name.equals(ms.name)) {
            return false;
        }
        if (this.mismatch(this.parameterTypes, ms.parameterTypes)) {
            return false;
        }
        return !this.mismatch(this.exceptionTypes, ms.exceptionTypes);
    }

    private boolean mismatch(Class[] a1, Class[] a2) {
        int a2Count;
        int a1Count = InternalUtils.size(a1);
        if (a1Count != (a2Count = InternalUtils.size(a2))) {
            return true;
        }
        for (int i = 0; i < a1Count; ++i) {
            if (a1[i] == a2[i]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuilder buffer = new StringBuilder();
        buffer.append(ClassFabUtils.toJavaClassName(this.returnType));
        buffer.append(" ");
        buffer.append(this.name);
        buffer.append("(");
        for (int i2 = 0; i2 < InternalUtils.size(this.parameterTypes); ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(ClassFabUtils.toJavaClassName(this.parameterTypes[i2]));
        }
        buffer.append(")");
        int _exceptionCount = InternalUtils.size(this.exceptionTypes);
        Object[] _exceptionNames = new String[_exceptionCount];
        for (i = 0; i < _exceptionCount; ++i) {
            _exceptionNames[i] = this.exceptionTypes[i].getName();
        }
        Arrays.sort(_exceptionNames);
        for (i = 0; i < _exceptionCount; ++i) {
            if (i == 0) {
                buffer.append(" throws ");
            } else {
                buffer.append(", ");
            }
            buffer.append((String)_exceptionNames[i]);
        }
        return buffer.toString();
    }

    public String getUniqueId() {
        StringBuilder buffer = new StringBuilder(this.name);
        buffer.append("(");
        for (int i = 0; i < InternalUtils.size(this.parameterTypes); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(ClassFabUtils.toJavaClassName(this.parameterTypes[i]));
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean isOverridingSignatureOf(MethodSignature ms) {
        if (this.returnType != ms.returnType) {
            return false;
        }
        if (!this.name.equals(ms.name)) {
            return false;
        }
        if (this.mismatch(this.parameterTypes, ms.parameterTypes)) {
            return false;
        }
        return this.exceptionsEncompass(ms.exceptionTypes);
    }

    private boolean exceptionsEncompass(Class[] otherExceptions) {
        int ourCount = InternalUtils.size(this.exceptionTypes);
        int otherCount = InternalUtils.size(otherExceptions);
        if (ourCount == 0) {
            return otherCount == 0;
        }
        boolean[] matched = new boolean[otherCount];
        int unmatched = otherCount;
        for (int i = 0; i < ourCount && unmatched > 0; ++i) {
            for (int j = 0; j < otherCount; ++j) {
                if (matched[j] || !this.exceptionTypes[i].isAssignableFrom(otherExceptions[j])) continue;
                matched[j] = true;
                --unmatched;
            }
        }
        return unmatched == 0;
    }
}

