/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.IdMatcher;
import org.apache.tapestry5.ioc.Orderable;
import org.apache.tapestry5.ioc.internal.IdMatcherImpl;
import org.apache.tapestry5.ioc.internal.OrIdMatcher;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.DependencyNode;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.internal.util.UtilMessages;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Orderer<T> {
    private final OneShotLock lock = new OneShotLock();
    private final Logger logger;
    private final List<Orderable> orderables = CollectionFactory.newList();
    private final Map<String, Orderable<T>> idToOrderable = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, DependencyNode<T>> dependencyNodesById = CollectionFactory.newCaseInsensitiveMap();
    private DependencyNode<T> trailer;
    final DependencyLinker<T> _before = new DependencyLinker<T>(){

        @Override
        public void link(DependencyNode<T> source, DependencyNode<T> target) {
            target.addDependency(source);
        }
    };
    final DependencyLinker<T> _after = new DependencyLinker<T>(){

        @Override
        public void link(DependencyNode<T> source, DependencyNode<T> target) {
            source.addDependency(target);
        }
    };

    public Orderer(Logger logger) {
        this.logger = logger;
    }

    public void add(Orderable<T> orderable) {
        this.lock.check();
        String id = orderable.getId();
        if (this.idToOrderable.containsKey(id)) {
            this.logger.warn(UtilMessages.duplicateOrderer(id));
            return;
        }
        this.orderables.add(orderable);
        this.idToOrderable.put(id, orderable);
    }

    public void override(Orderable<T> orderable) {
        this.lock.check();
        String id = orderable.getId();
        Orderable<T> existing = this.idToOrderable.get(id);
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Override for object '%s' is invalid as it does not match an existing object.", id));
        }
        this.orderables.remove(existing);
        this.orderables.add(orderable);
        this.idToOrderable.put(id, orderable);
    }

    public void add(String id, T target, String ... constraints) {
        this.lock.check();
        this.add(new Orderable<T>(id, target, constraints));
    }

    public void override(String id, T target, String ... constraints) {
        this.lock.check();
        this.override(new Orderable<T>(id, target, constraints));
    }

    public List<T> getOrdered() {
        this.lock.lock();
        this.initializeGraph();
        List result = CollectionFactory.newList();
        for (Orderable<T> orderable : this.trailer.getOrdered()) {
            T target = orderable.getTarget();
            if (target == null) continue;
            result.add(target);
        }
        return result;
    }

    private void initializeGraph() {
        this.trailer = new DependencyNode<Object>(this.logger, new Orderable<Object>("*-trailer-*", null, new String[0]));
        this.addNodes();
        this.addDependencies();
    }

    private void addNodes() {
        for (Orderable orderable : this.orderables) {
            DependencyNode node = new DependencyNode(this.logger, orderable);
            this.dependencyNodesById.put(orderable.getId(), node);
            this.trailer.addDependency(node);
        }
    }

    private void addDependencies() {
        for (Orderable orderable : this.orderables) {
            this.addDependencies(orderable);
        }
    }

    private void addDependencies(Orderable<T> orderable) {
        String sourceId = orderable.getId();
        for (String constraint : orderable.getConstraints()) {
            this.addDependencies(sourceId, constraint);
        }
    }

    private void addDependencies(String sourceId, String constraint) {
        int colonx = constraint.indexOf(58);
        String type = colonx > 0 ? constraint.substring(0, colonx) : null;
        DependencyLinker<T> linker = null;
        if ("after".equals(type)) {
            linker = this._after;
        } else if ("before".equals(type)) {
            linker = this._before;
        }
        if (linker == null) {
            this.logger.warn(UtilMessages.constraintFormat(constraint, sourceId));
            return;
        }
        String patternList = constraint.substring(colonx + 1);
        this.linkNodes(sourceId, patternList, linker);
    }

    private void linkNodes(String sourceId, String patternList, DependencyLinker<T> linker) {
        Collection<DependencyNode<T>> nodes = this.findDependencies(sourceId, patternList);
        DependencyNode<T> source = this.dependencyNodesById.get(sourceId);
        for (DependencyNode<T> target : nodes) {
            linker.link(source, target);
        }
    }

    private Collection<DependencyNode<T>> findDependencies(String sourceId, String patternList) {
        IdMatcher matcher = this.buildMatcherForPattern(patternList);
        List<DependencyNode<T>> result = CollectionFactory.newList();
        for (String id : this.dependencyNodesById.keySet()) {
            if (sourceId.equals(id) || !matcher.matches(id)) continue;
            result.add(this.dependencyNodesById.get(id));
        }
        return result;
    }

    private IdMatcher buildMatcherForPattern(String patternList) {
        List<IdMatcher> matchers = CollectionFactory.newList();
        for (String pattern : patternList.split(",")) {
            IdMatcherImpl matcher = new IdMatcherImpl(pattern.trim());
            matchers.add(matcher);
        }
        return matchers.size() == 1 ? (IdMatcher)matchers.get(0) : new OrIdMatcher(matchers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface DependencyLinker<T> {
        public void link(DependencyNode<T> var1, DependencyNode<T> var2);
    }
}

