/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.ioc.AdvisorDef;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.Locatable;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.ServiceLifecycle2;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectResource;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.DecoratorDef;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.def.ModuleDef2;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.def.ServiceDef2;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.UtilMessages;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.ClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalUtils {
    private static final String NAME_PREFIX = "_$";
    private static final Pattern NAME_PATTERN = Pattern.compile("^[_|$]*([\\w|$]+?)[_|$]*$", 2);

    public static String asString(Method method, ClassFactory classFactory) {
        Location location = classFactory.getMethodLocation(method);
        return location != null ? location.toString() : InternalUtils.asString(method);
    }

    public static String asString(Method method) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.getDeclaringClass().getName());
        buffer.append(".");
        buffer.append(method.getName());
        buffer.append("(");
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            String name = method.getParameterTypes()[i].getSimpleName();
            buffer.append(name);
        }
        return buffer.append(")").toString();
    }

    public static int size(Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static int size(Collection collection) {
        return collection == null ? 0 : collection.size();
    }

    public static String stripMemberName(String memberName) {
        Defense.notBlank(memberName, "memberName");
        Matcher matcher = NAME_PATTERN.matcher(memberName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Input '%s' is not a valid Java identifier.", memberName));
        }
        return matcher.group(1);
    }

    public static String createMemberName(String memberName) {
        return NAME_PREFIX + InternalUtils.stripMemberName(memberName);
    }

    public static List<String> toList(Enumeration e) {
        List<String> result = CollectionFactory.newList();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    public static <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        for (Annotation a : annotations) {
            if (!annotationClass.isInstance(a)) continue;
            return (T)((Annotation)annotationClass.cast(a));
        }
        return null;
    }

    private static Object calculateInjection(Class injectionType, Type genericType, final Annotation[] annotations, ObjectLocator locator, InjectionResources resources) {
        Object result;
        AnnotationProvider provider = new AnnotationProvider(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return InternalUtils.findAnnotation(annotations, annotationClass);
            }
        };
        InjectService is = provider.getAnnotation(InjectService.class);
        if (is != null) {
            String serviceId = is.value();
            return locator.getService(serviceId, injectionType);
        }
        if (provider.getAnnotation(Inject.class) == null && (result = resources.findResource(injectionType, genericType)) != null) {
            return result;
        }
        return locator.getObject(injectionType, provider);
    }

    public static Object[] calculateParametersForMethod(Method method, ObjectLocator locator, InjectionResources resources, OperationTracker tracker) {
        return InternalUtils.calculateParameters(locator, resources, method.getParameterTypes(), method.getGenericParameterTypes(), method.getParameterAnnotations(), tracker);
    }

    public static Object[] calculateParametersForConstructor(Constructor constructor, ObjectLocator locator, InjectionResources resources, OperationTracker tracker) {
        return InternalUtils.calculateParameters(locator, resources, constructor.getParameterTypes(), constructor.getGenericParameterTypes(), constructor.getParameterAnnotations(), tracker);
    }

    public static Object[] calculateParameters(final ObjectLocator locator, final InjectionResources resources, Class[] parameterTypes, Type[] genericTypes, Annotation[][] parameterAnnotations, OperationTracker tracker) {
        int parameterCount = parameterTypes.length;
        Object[] parameters = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            final Class type = parameterTypes[i];
            final Type genericType = genericTypes[i];
            final Annotation[] annotations = parameterAnnotations[i];
            String description = String.format("Determining injection value for parameter #%d (%s)", i + 1, ClassFabUtils.toJavaClassName(type));
            Invokable<Object> operation = new Invokable<Object>(){

                @Override
                public Object invoke() {
                    return InternalUtils.calculateInjection(type, genericType, annotations, locator, resources);
                }
            };
            parameters[i] = tracker.invoke(description, operation);
        }
        return parameters;
    }

    public static void injectIntoFields(final Object object, final ObjectLocator locator, final InjectionResources resources, OperationTracker tracker) {
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (final Field f : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                final AnnotationProvider ap = new AnnotationProvider(){

                    @Override
                    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                        return f.getAnnotation(annotationClass);
                    }
                };
                String description = String.format("Calculating injection value for field '%s' (%s)", f.getName(), ClassFabUtils.toJavaClassName(f.getType()));
                tracker.run(description, new Runnable(){

                    public void run() {
                        Class<?> fieldType = f.getType();
                        InjectService is = ap.getAnnotation(InjectService.class);
                        if (is != null) {
                            InternalUtils.inject(object, f, locator.getService(is.value(), fieldType));
                            return;
                        }
                        if (ap.getAnnotation(Inject.class) != null) {
                            InternalUtils.inject(object, f, locator.getObject(fieldType, ap));
                            return;
                        }
                        if (ap.getAnnotation(InjectResource.class) != null) {
                            Object value = resources.findResource(fieldType, f.getGenericType());
                            if (value == null) {
                                throw new RuntimeException(UtilMessages.injectResourceFailure(f.getName(), fieldType));
                            }
                            InternalUtils.inject(object, f, value);
                            return;
                        }
                    }
                });
            }
        }
    }

    public static void invokePostInjectionMethods(final Object object, final ObjectLocator locator, final InjectionResources injectionResources, final OperationTracker tracker) {
        for (final Method m : object.getClass().getMethods()) {
            if (m.getAnnotation(PostInjection.class) == null) continue;
            String description = String.format("Invoking post-inject method %s", m);
            tracker.run(description, new Runnable(){

                public void run() {
                    Throwable fail = null;
                    try {
                        Object[] parameters = InternalUtils.calculateParametersForMethod(m, locator, injectionResources, tracker);
                        m.invoke(object, parameters);
                    }
                    catch (InvocationTargetException ex) {
                        fail = ex.getTargetException();
                    }
                    catch (Exception ex) {
                        fail = ex;
                    }
                    if (fail != null) {
                        throw new RuntimeException(String.format("Exception invoking method %s: %s", m, InternalUtils.toMessage(fail)), fail);
                    }
                }
            });
        }
    }

    private static synchronized void inject(Object target, Field field, Object value) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(target, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to set field '%s' of %s to %s: %s", field.getName(), target, value, InternalUtils.toMessage(ex)));
        }
    }

    public static String join(List elements) {
        return InternalUtils.join(elements, ", ");
    }

    public static String join(List elements, String separator) {
        switch (elements.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return elements.get(0).toString();
            }
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Object o : elements) {
            String string;
            if (!first) {
                buffer.append(separator);
            }
            if ((string = String.valueOf(o)).equals("")) {
                string = "(blank)";
            }
            buffer.append(string);
            first = false;
        }
        return buffer.toString();
    }

    public static String joinSorted(Collection elements) {
        if (elements == null || elements.isEmpty()) {
            return "(none)";
        }
        List list = CollectionFactory.newList();
        for (Object o : elements) {
            list.add(String.valueOf(o));
        }
        Collections.sort(list);
        return InternalUtils.join(list);
    }

    public static boolean isBlank(String input) {
        return input == null || input.length() == 0 || input.trim().length() == 0;
    }

    public static boolean isNonBlank(String input) {
        return !InternalUtils.isBlank(input);
    }

    public static String capitalize(String input) {
        if (input.length() == 0) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static Location locationOf(Object location) {
        if (location == null) {
            return null;
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        if (location instanceof Locatable) {
            return ((Locatable)location).getLocation();
        }
        return null;
    }

    public static List<String> sortedKeys(Map map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List<String> keys = CollectionFactory.newList();
        for (Object o : map.keySet()) {
            keys.add(String.valueOf(o));
        }
        Collections.sort(keys);
        return keys;
    }

    public static <K, V> Set<K> keys(Map<K, V> map) {
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static <T> Iterator<T> reverseIterator(List<T> list) {
        final ListIterator<T> normal = list.listIterator(list.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return normal.hasPrevious();
            }

            @Override
            public T next() {
                return normal.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean containsSymbols(String input) {
        return input.contains("${");
    }

    public static String lastTerm(String input) {
        Defense.notBlank(input, "input");
        int dotx = input.lastIndexOf(46);
        if (dotx < 0) {
            return input;
        }
        return input.substring(dotx + 1);
    }

    public static Constructor findAutobuildConstructor(Class clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        switch (constructors.length) {
            case 1: {
                return constructors[0];
            }
            case 0: {
                return null;
            }
        }
        for (Constructor<?> c : constructors) {
            if (c.getAnnotation(Inject.class) == null) continue;
            return c;
        }
        Comparator<Constructor> comparator = new Comparator<Constructor>(){

            @Override
            public int compare(Constructor o1, Constructor o2) {
                return o2.getParameterTypes().length - o1.getParameterTypes().length;
            }
        };
        Arrays.sort(constructors, comparator);
        return constructors[0];
    }

    public static <K, V> void addToMapList(Map<K, List<V>> map, K key, V value) {
        List<Object> list = map.get(key);
        if (list == null) {
            list = CollectionFactory.newList();
            map.put(key, list);
        }
        list.add(value);
    }

    public static void validateMarkerAnnotation(Class markerClass) {
        Retention policy = markerClass.getAnnotation(Retention.class);
        if (policy != null && policy.value() == RetentionPolicy.RUNTIME) {
            return;
        }
        throw new IllegalArgumentException(UtilMessages.badMarkerAnnotation(markerClass));
    }

    public static void validateMarkerAnnotations(Class[] markerClasses) {
        for (Class markerClass : markerClasses) {
            InternalUtils.validateMarkerAnnotation(markerClass);
        }
    }

    public static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String toMessage(Throwable exception) {
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.getClass().getName();
    }

    public static void validateConstructorForAutobuild(Constructor constructor) {
        Class clazz = constructor.getDeclaringClass();
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException(String.format("Class %s is not a public class and may not be autobuilt.", clazz.getName()));
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new IllegalArgumentException(String.format("Constructor %s is not public and may not be used for autobuilding an instance of the class. You should make the constructor public, or mark an alternate public constructor with the @Inject annotation.", constructor));
        }
    }

    public static ServiceDef2 toServiceDef2(final ServiceDef sd) {
        if (sd instanceof ServiceDef2) {
            return (ServiceDef2)sd;
        }
        return new ServiceDef2(){

            @Override
            public boolean isPreventDecoration() {
                return false;
            }

            @Override
            public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                return sd.createServiceCreator(resources);
            }

            @Override
            public String getServiceId() {
                return sd.getServiceId();
            }

            @Override
            public Set<Class> getMarkers() {
                return sd.getMarkers();
            }

            @Override
            public Class getServiceInterface() {
                return sd.getServiceInterface();
            }

            @Override
            public String getServiceScope() {
                return sd.getServiceScope();
            }

            @Override
            public boolean isEagerLoad() {
                return sd.isEagerLoad();
            }
        };
    }

    public static ModuleDef2 toModuleDef2(final ModuleDef md) {
        if (md instanceof ModuleDef2) {
            return (ModuleDef2)md;
        }
        return new ModuleDef2(){

            @Override
            public Set<AdvisorDef> getAdvisorDefs() {
                return Collections.emptySet();
            }

            @Override
            public Class getBuilderClass() {
                return md.getBuilderClass();
            }

            @Override
            public Set<ContributionDef> getContributionDefs() {
                return md.getContributionDefs();
            }

            @Override
            public Set<DecoratorDef> getDecoratorDefs() {
                return md.getDecoratorDefs();
            }

            @Override
            public String getLoggerName() {
                return md.getLoggerName();
            }

            @Override
            public ServiceDef getServiceDef(String serviceId) {
                return md.getServiceDef(serviceId);
            }

            @Override
            public Set<String> getServiceIds() {
                return md.getServiceIds();
            }
        };
    }

    public static ServiceLifecycle2 toServiceLifecycle2(final ServiceLifecycle lifecycle) {
        if (lifecycle instanceof ServiceLifecycle2) {
            return (ServiceLifecycle2)lifecycle;
        }
        return new ServiceLifecycle2(){

            public boolean requiresProxy() {
                return true;
            }

            public Object createService(ServiceResources resources, ObjectCreator creator) {
                return lifecycle.createService(resources, creator);
            }

            public boolean isSingleton() {
                return lifecycle.isSingleton();
            }
        };
    }
}

