/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Map;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodIterator;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.apache.tapestry5.ioc.services.StrategyBuilder;
import org.apache.tapestry5.ioc.util.BodyBuilder;
import org.apache.tapestry5.ioc.util.StrategyRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategyBuilderImpl
implements StrategyBuilder {
    private final ClassFactory classFactory;

    public StrategyBuilderImpl(@Builtin ClassFactory classFactory) {
        this.classFactory = classFactory;
    }

    @Override
    public <S> S build(StrategyRegistry<S> registry) {
        Class<S> interfaceClass = registry.getAdapterType();
        Class implClass = this.createImplClass(interfaceClass);
        try {
            Object raw = implClass.getConstructors()[0].newInstance(registry);
            return interfaceClass.cast(raw);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <S> S build(Class<S> adapterType, Map<Class, S> registrations) {
        StrategyRegistry<S> registry = StrategyRegistry.newInstance(adapterType, registrations);
        return this.build(registry);
    }

    private Class createImplClass(Class interfaceClass) {
        ClassFab cf = this.classFactory.newClass(interfaceClass);
        String interfaceClassName = interfaceClass.getName();
        cf.addField("_registry", 18, StrategyRegistry.class);
        cf.addConstructor(new Class[]{StrategyRegistry.class}, null, "_registry = $1;");
        BodyBuilder builder = new BodyBuilder();
        MethodIterator mi = new MethodIterator(interfaceClass);
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            builder.clear();
            builder.begin();
            builder.addln("Object selector = $1;", new Object[0]);
            builder.addln("%s adapter = (%<s) _registry.getByInstance(selector);", interfaceClassName);
            builder.addln("return ($r) adapter.%s($$);", sig.getName());
            builder.end();
            cf.addMethod(1, sig, builder.toString());
        }
        if (!mi.getToString()) {
            cf.addToString(String.format("<Strategy for %s>", interfaceClassName));
        }
        return cf.createClass();
    }
}

