/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.services.ClassPropertyAdapterImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessImpl
implements PropertyAccess {
    private final Map<Class, ClassPropertyAdapter> adapters = CollectionFactory.newConcurrentMap();

    @Override
    public Object get(Object instance, String propertyName) {
        return this.getAdapter(instance).get(instance, propertyName);
    }

    @Override
    public void set(Object instance, String propertyName, Object value) {
        this.getAdapter(instance).set(instance, propertyName, value);
    }

    @Override
    public synchronized void clearCache() {
        this.adapters.clear();
        Introspector.flushCaches();
    }

    @Override
    public ClassPropertyAdapter getAdapter(Object instance) {
        return this.getAdapter(instance.getClass());
    }

    @Override
    public ClassPropertyAdapter getAdapter(Class forClass) {
        ClassPropertyAdapter result = this.adapters.get(forClass);
        if (result == null) {
            result = this.buildAdapter(forClass);
            this.adapters.put(forClass, result);
        }
        return result;
    }

    private synchronized ClassPropertyAdapter buildAdapter(Class forClass) {
        try {
            BeanInfo info = Introspector.getBeanInfo(forClass);
            List<PropertyDescriptor> descriptors = CollectionFactory.newList();
            this.addAll(descriptors, info.getPropertyDescriptors());
            if (forClass.isInterface()) {
                this.addPropertiesFromExtendedInterfaces(forClass, descriptors);
            }
            return new ClassPropertyAdapterImpl(forClass, descriptors);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> void addAll(List<T> list, T[] array) {
        list.addAll(Arrays.asList(array));
    }

    private void addPropertiesFromExtendedInterfaces(Class forClass, List<PropertyDescriptor> descriptors) throws IntrospectionException {
        LinkedList queue = CollectionFactory.newLinkedList();
        this.addAll(queue, forClass.getInterfaces());
        while (!queue.isEmpty()) {
            Class c = (Class)queue.removeFirst();
            BeanInfo info = Introspector.getBeanInfo(c);
            this.addAll(descriptors, info.getPropertyDescriptors());
            this.addAll(queue, c.getInterfaces());
        }
    }
}

