/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassNameLocator;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.ioc.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameLocatorImpl
implements ClassNameLocator {
    private static final String CLASS_SUFFIX = ".class";
    private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
    private final ClasspathURLConverter converter;
    private final Pattern CLASS_NAME_PATTERN = Pattern.compile("^[_a-z][a-z0-9_]*\\.class$", 2);
    private final Pattern FOLDER_NAME_PATTERN = Pattern.compile("^[_a-z][a-z0-9_]*$", 2);

    public ClassNameLocatorImpl(ClasspathURLConverter converter) {
        this.converter = converter;
    }

    @Override
    public synchronized Collection<String> locateClassNames(String packageName) {
        String packagePath = packageName.replace('.', '/') + "/";
        try {
            return this.findClassesWithinPath(packagePath);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Collection<String> findClassesWithinPath(String packagePath) throws IOException {
        List<String> result = CollectionFactory.newList();
        Enumeration<URL> urls = this.contextClassLoader.getResources(packagePath);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URL converted = this.converter.convert(url);
            this.scanURL(packagePath, result, converted);
        }
        return result;
    }

    private void scanURL(String packagePath, Collection<String> componentClassNames, URL url) throws IOException {
        URLConnection connection = url.openConnection();
        JarFile jarFile = connection instanceof JarURLConnection ? ((JarURLConnection)connection).getJarFile() : this.getAlternativeJarFile(url);
        if (jarFile != null) {
            this.scanJarFile(packagePath, componentClassNames, jarFile);
        } else if (this.supportsDirStream(url)) {
            Stack<Queued> queue = CollectionFactory.newStack();
            queue.push(new Queued(url, packagePath));
            while (!queue.isEmpty()) {
                Queued queued = (Queued)queue.pop();
                this.scanDirStream(queued.packagePath, queued.packageURL, componentClassNames, queue);
            }
        } else {
            String packageName = packagePath.replace("/", ".");
            if (packageName.endsWith(".")) {
                packageName = packageName.substring(0, packageName.length() - 1);
            }
            this.scanDir(packageName, new File(url.getFile()), componentClassNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean supportsDirStream(URL packageURL) {
        InputStream is = null;
        try {
            is = packageURL.openStream();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ex) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            InternalUtils.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirStream(String packagePath, URL packageURL, Collection<String> componentClassNames, Stack<Queued> queue) throws IOException {
        BufferedInputStream is;
        try {
            is = new BufferedInputStream(packageURL.openStream());
        }
        catch (FileNotFoundException ex) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(is);
        LineNumberReader lineReader = new LineNumberReader(reader);
        String packageName = null;
        try {
            String line;
            while ((line = lineReader.readLine()) != null) {
                if (this.CLASS_NAME_PATTERN.matcher(line).matches()) {
                    if (packageName == null) {
                        packageName = packagePath.replace('/', '.');
                    }
                    String fullClassName = packageName + line.substring(0, line.length() - CLASS_SUFFIX.length());
                    componentClassNames.add(fullClassName);
                    continue;
                }
                if (!this.FOLDER_NAME_PATTERN.matcher(line).matches()) continue;
                URL newURL = new URL(packageURL.toExternalForm() + line + "/");
                String newPackagePath = packagePath + line + "/";
                queue.push(new Queued(newURL, newPackagePath));
            }
            lineReader.close();
            lineReader = null;
        }
        finally {
            InternalUtils.close(lineReader);
        }
    }

    private void scanJarFile(String packagePath, Collection<String> componentClassNames, JarFile jarFile) {
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            String name = e.nextElement().getName();
            if (!name.startsWith(packagePath) || !name.endsWith(CLASS_SUFFIX) || name.contains("$")) continue;
            String className = name.substring(0, name.length() - CLASS_SUFFIX.length()).replace("/", ".");
            componentClassNames.add(className);
        }
    }

    private void scanDir(String packageName, File dir, Collection<String> componentClassNames) {
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                String fileName = file.getName();
                if (file.isDirectory()) {
                    this.scanDir(packageName + "." + fileName, file, componentClassNames);
                    continue;
                }
                if (!fileName.endsWith(CLASS_SUFFIX)) continue;
                String className = packageName + "." + fileName.substring(0, fileName.length() - CLASS_SUFFIX.length());
                componentClassNames.add(className);
            }
        }
    }

    private JarFile getAlternativeJarFile(URL url) throws IOException {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf(33);
        }
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
            return new JarFile(jarFileUrl);
        }
        return null;
    }

    static class Queued {
        final URL packageURL;
        final String packagePath;

        public Queued(URL packageURL, String packagePath) {
            this.packageURL = packageURL;
            this.packagePath = packagePath;
        }
    }
}

