/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Modifier;
import java.util.Formatter;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.tapestry5.ioc.internal.services.AbstractFab;
import org.apache.tapestry5.ioc.internal.services.CtClassSource;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.MethodIterator;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.slf4j.Logger;

public class ClassFabImpl
extends AbstractFab
implements ClassFab {
    private static final Map<Class, String> DEFAULT_RETURN = CollectionFactory.newMap();
    private final StringBuilder description = new StringBuilder();
    private final Formatter formatter = new Formatter(this.description);
    private final Set<MethodSignature> addedSignatures = CollectionFactory.newSet();

    public ClassFabImpl(CtClassSource source, CtClass ctClass, Logger logger) {
        super(source, ctClass, logger);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("ClassFab[\n");
        try {
            buffer.append(this.buildClassAndInheritance());
            buffer.append(this.description.toString());
        }
        catch (Exception ex) {
            buffer.append(" *** ");
            buffer.append(ex);
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    private String buildClassAndInheritance() throws NotFoundException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Modifier.toString(this.getCtClass().getModifiers()));
        buffer.append(" class ");
        buffer.append(this.getName());
        buffer.append(" extends ");
        buffer.append(this.getCtClass().getSuperclass().getName());
        buffer.append("\n");
        CtClass[] interfaces = this.getCtClass().getInterfaces();
        if (interfaces.length > 0) {
            buffer.append("  implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(interfaces[i].getName());
            }
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    String getName() {
        return this.getCtClass().getName();
    }

    public void addField(String name, Class type) {
        this.addField(name, 2, type);
    }

    public void addField(String name, int modifiers, Class type) {
        this.lock.check();
        CtClass ctType = this.toCtClass(type);
        try {
            CtField field = new CtField(ctType, name, this.getCtClass());
            field.setModifiers(modifiers);
            this.getCtClass().addField(field);
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException(ServiceMessages.unableToAddField(name, this.getCtClass(), ex), ex);
        }
        this.formatter.format("%s %s %s;\n\n", Modifier.toString(modifiers), ClassFabUtils.toJavaClassName(type), name);
    }

    public void proxyMethodsToDelegate(Class serviceInterface, String delegateExpression, String toString) {
        this.lock.check();
        this.addInterface(serviceInterface);
        MethodIterator mi = new MethodIterator(serviceInterface);
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            String body = String.format("return ($r) %s.%s($$);", delegateExpression, sig.getName());
            this.addMethod(1, sig, body);
        }
        if (!mi.getToString()) {
            this.addToString(toString);
        }
    }

    public void addToString(String toString) {
        this.lock.check();
        MethodSignature sig = new MethodSignature(String.class, "toString", null, null);
        this.addMethod(1, sig, String.format("return \"%s\";", toString));
    }

    public void addMethod(int modifiers, MethodSignature ms, String body) {
        this.lock.check();
        if (this.addedSignatures.contains(ms)) {
            throw new RuntimeException(ServiceMessages.duplicateMethodInClass(ms, this));
        }
        CtClass ctReturnType = this.toCtClass(ms.getReturnType());
        CtClass[] ctParameters = this.toCtClasses(ms.getParameterTypes());
        CtClass[] ctExceptions = this.toCtClasses(ms.getExceptionTypes());
        CtMethod method = new CtMethod(ctReturnType, ms.getName(), ctParameters, this.getCtClass());
        try {
            method.setModifiers(modifiers);
            method.setBody(body);
            method.setExceptionTypes(ctExceptions);
            this.getCtClass().addMethod(method);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToAddMethod(ms, this.getCtClass(), ex), ex);
        }
        this.addedSignatures.add(ms);
        this.formatter.format("%s %s %s", Modifier.toString(modifiers), ClassFabUtils.toJavaClassName(ms.getReturnType()), ms.getName());
        this.addMethodDetailsToDescription(ms.getParameterTypes(), ms.getExceptionTypes(), body);
        this.description.append("\n\n");
    }

    public void addNoOpMethod(MethodSignature signature) {
        this.lock.check();
        Class returnType = signature.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            this.addMethod(1, signature, "return;");
            return;
        }
        String value = "null";
        if (returnType.isPrimitive() && (value = DEFAULT_RETURN.get(returnType)) == null) {
            value = "0";
        }
        this.addMethod(1, signature, "return " + value + ";");
    }

    public void addConstructor(Class[] parameterTypes, Class[] exceptions, String body) {
        Defense.notBlank(body, "body");
        this.lock.check();
        CtClass[] ctParameters = this.toCtClasses(parameterTypes);
        CtClass[] ctExceptions = this.toCtClasses(exceptions);
        try {
            CtConstructor constructor = new CtConstructor(ctParameters, this.getCtClass());
            constructor.setExceptionTypes(ctExceptions);
            constructor.setBody(body);
            this.getCtClass().addConstructor(constructor);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToAddConstructor(this.getCtClass(), ex), ex);
        }
        this.description.append("public ");
        this.description.append(this.getName());
        this.addMethodDetailsToDescription(parameterTypes, exceptions, body);
        this.description.append("\n\n");
    }

    private void addMethodDetailsToDescription(Class[] parameterTypes, Class[] exceptions, String body) {
        int i;
        this.description.append("(");
        int count = InternalUtils.size(parameterTypes);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                this.description.append(", ");
            }
            this.description.append(ClassFabUtils.toJavaClassName(parameterTypes[i]));
            this.description.append(" $");
            this.description.append(i + 1);
        }
        this.description.append(")");
        count = InternalUtils.size(exceptions);
        for (i = 0; i < count; ++i) {
            if (i == 0) {
                this.description.append("\n  throws ");
            } else {
                this.description.append(", ");
            }
            this.description.append(exceptions[i].getName());
        }
        this.description.append("\n");
        this.description.append(body);
    }

    static {
        DEFAULT_RETURN.put(Boolean.TYPE, "false");
        DEFAULT_RETURN.put(Long.TYPE, "0L");
        DEFAULT_RETURN.put(Float.TYPE, "0.0f");
        DEFAULT_RETURN.put(Double.TYPE, "0.0d");
    }
}

