/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.ioc.internal.services.AdvisedMethodInvocationBuilder;
import org.apache.tapestry5.ioc.internal.services.ConstantInjectorImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.services.AspectInterceptorBuilder;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectInterceptorBuilderImpl<T>
implements AspectInterceptorBuilder<T> {
    private final ClassFactory classFactory;
    private final Class<T> serviceInterface;
    private final ClassFab interceptorFab;
    private final ConstantInjectorImpl injector;
    private final String delegateFieldName;
    private final String description;
    private final OneShotLock lock = new OneShotLock();
    private final Set<Method> remainingMethods = CollectionFactory.newSet();
    private final Map<Method, AdvisedMethodInvocationBuilder> methodToBuilder = CollectionFactory.newMap();
    private boolean sawToString;

    public AspectInterceptorBuilderImpl(ClassFactory classFactory, Class<T> serviceInterface, T delegate, String description) {
        this.classFactory = classFactory;
        this.serviceInterface = serviceInterface;
        this.description = description;
        this.interceptorFab = this.classFactory.newClass(serviceInterface);
        this.injector = new ConstantInjectorImpl(this.interceptorFab);
        this.delegateFieldName = this.injector.inject(serviceInterface, delegate);
        this.remainingMethods.addAll(Arrays.asList(serviceInterface.getMethods()));
    }

    @Override
    public void adviseMethod(Method method, MethodAdvice advice) {
        Defense.notNull(method, "method");
        Defense.notNull(advice, "advice");
        this.lock.check();
        AdvisedMethodInvocationBuilder builder = this.methodToBuilder.get(method);
        if (builder == null) {
            if (!this.remainingMethods.contains(method)) {
                throw new IllegalArgumentException(String.format("Method %s is not defined for interface %s.", method, this.serviceInterface));
            }
            this.remainingMethods.remove(method);
            this.sawToString |= ClassFabUtils.isToString(method);
            builder = new AdvisedMethodInvocationBuilder(this.classFactory, this.serviceInterface, method);
            this.methodToBuilder.put(method, builder);
        }
        builder.addAdvice(advice);
    }

    @Override
    public void adviseAllMethods(MethodAdvice advice) {
        for (Method m : this.serviceInterface.getMethods()) {
            this.adviseMethod(m, advice);
        }
    }

    @Override
    public Class getInterface() {
        return this.serviceInterface;
    }

    @Override
    public T build() {
        this.lock.lock();
        for (AdvisedMethodInvocationBuilder builder : this.methodToBuilder.values()) {
            builder.commit(this.interceptorFab, this.delegateFieldName, this.injector);
        }
        this.addPassthruMethods();
        if (!this.sawToString) {
            this.interceptorFab.addToString(this.description);
        }
        this.injector.implementConstructor();
        Class interceptorClass = this.interceptorFab.createClass();
        Object[] parameters = this.injector.getParameters();
        try {
            Constructor<?> constructor = interceptorClass.getConstructors()[0];
            Object raw = constructor.newInstance(parameters);
            return this.serviceInterface.cast(raw);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addPassthruMethods() {
        for (Method m : this.remainingMethods) {
            this.sawToString |= ClassFabUtils.isToString(m);
            MethodSignature sig = new MethodSignature(m);
            String body = String.format("return ($r) %s.%s($$);", this.delegateFieldName, m.getName());
            this.interceptorFab.addMethod(1, sig, body);
        }
    }
}

