/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.ioc.internal.services.AspectInterceptorBuilderImpl;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.services.AspectDecorator;
import org.apache.tapestry5.ioc.services.AspectInterceptorBuilder;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectDecoratorImpl
implements AspectDecorator {
    private final ClassFactory classFactory;

    public AspectDecoratorImpl(@Builtin ClassFactory classFactory) {
        this.classFactory = classFactory;
    }

    @Override
    public <T> T build(Class<T> serviceInterface, T delegate, MethodAdvice advice, String description) {
        Defense.notNull(advice, "advice");
        AspectInterceptorBuilder<T> builder = this.createBuilder(serviceInterface, delegate, description);
        builder.adviseAllMethods(advice);
        return builder.build();
    }

    @Override
    public <T> AspectInterceptorBuilder<T> createBuilder(final Class<T> serviceInterface, final T delegate, final String description) {
        Defense.notNull(serviceInterface, "serviceInterface");
        Defense.notNull(delegate, "delegate");
        Defense.notBlank(description, "description");
        return new AspectInterceptorBuilder<T>(){
            private AspectInterceptorBuilder<T> builder;

            @Override
            public void adviseMethod(Method method, MethodAdvice advice) {
                this.getBuilder().adviseMethod(method, advice);
            }

            @Override
            public void adviseAllMethods(MethodAdvice advice) {
                this.getBuilder().adviseAllMethods(advice);
            }

            @Override
            public Class getInterface() {
                return serviceInterface;
            }

            @Override
            public T build() {
                return this.builder == null ? delegate : this.builder.build();
            }

            private AspectInterceptorBuilder<T> getBuilder() {
                if (this.builder == null) {
                    this.builder = new AspectInterceptorBuilderImpl<Object>(AspectDecoratorImpl.this.classFactory, serviceInterface, delegate, description);
                }
                return this.builder;
            }
        };
    }
}

