/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.internal.AbstractServiceCreator;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class ConstructorServiceCreator
extends AbstractServiceCreator {
    private final Constructor constructor;

    public ConstructorServiceCreator(ServiceBuilderResources resources, String creatorDescription, Constructor constructor) {
        super(resources, creatorDescription);
        this.constructor = constructor;
    }

    public String toString() {
        return this.creatorDescription;
    }

    public Object createObject() {
        Throwable failure = null;
        Object result = null;
        InternalUtils.validateConstructorForAutobuild(this.constructor);
        InjectionResources injectionResources = this.createInjectionResources();
        try {
            Object[] parameters = InternalUtils.calculateParametersForConstructor(this.constructor, this.resources, injectionResources, this.resources.getTracker());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(IOCMessages.invokingConstructor(this.creatorDescription));
            }
            result = this.constructor.newInstance(parameters);
            InternalUtils.injectIntoFields(result, this.resources, injectionResources, this.resources.getTracker());
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        if (failure != null) {
            throw new RuntimeException(IOCMessages.constructorError(this.creatorDescription, this.serviceId, failure), failure);
        }
        InternalUtils.invokePostInjectionMethods(result, this.resources, injectionResources, this.resources.getTracker());
        return result;
    }
}

