/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.List;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ThreadCleanupHub;
import org.apache.tapestry.ioc.services.ThreadCleanupListener;
import org.slf4j.Logger;

public class ThreadCleanupHubImpl
implements ThreadCleanupHub {
    private final Logger _logger;
    private final ListHolder _holder = new ListHolder();

    public ThreadCleanupHubImpl(Logger logger) {
        this._logger = logger;
    }

    public void addThreadCleanupListener(ThreadCleanupListener listener) {
        ((List)this._holder.get()).add(listener);
    }

    public void cleanup() {
        List listeners = (List)this._holder.get();
        this._holder.remove();
        for (ThreadCleanupListener listener : listeners) {
            try {
                listener.threadDidCleanup();
            }
            catch (Exception ex) {
                this._logger.warn(ServiceMessages.threadCleanupError(listener, ex), (Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListHolder
    extends ThreadLocal<List<ThreadCleanupListener>> {
        private ListHolder() {
        }

        @Override
        protected List<ThreadCleanupListener> initialValue() {
            return CollectionFactory.newList();
        }
    }
}

