/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.lang.reflect.Constructor;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.services.Builtin;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.MethodSignature;
import org.apache.tapestry.ioc.services.PropertyAccess;
import org.apache.tapestry.ioc.services.PropertyAdapter;
import org.apache.tapestry.ioc.services.PropertyShadowBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyShadowBuilderImpl
implements PropertyShadowBuilder {
    private final ClassFactory _classFactory;
    private final PropertyAccess _propertyAccess;

    public PropertyShadowBuilderImpl(@Builtin ClassFactory classFactory, PropertyAccess propertyAccess) {
        this._classFactory = classFactory;
        this._propertyAccess = propertyAccess;
    }

    @Override
    public <T> T build(Object source, String propertyName, Class<T> propertyType) {
        Class<?> sourceClass = source.getClass();
        PropertyAdapter adapter = this._propertyAccess.getAdapter(sourceClass).getPropertyAdapter(propertyName);
        if (adapter == null) {
            throw new RuntimeException(ServiceMessages.noSuchProperty(sourceClass, propertyName));
        }
        if (!adapter.isRead()) {
            throw new RuntimeException(ServiceMessages.readNotSupported(source, propertyName));
        }
        if (!propertyType.isAssignableFrom(adapter.getType())) {
            throw new RuntimeException(ServiceMessages.propertyTypeMismatch(propertyName, sourceClass, adapter.getType(), propertyType));
        }
        ClassFab cf = this._classFactory.newClass(propertyType);
        cf.addField("_source", 18, sourceClass);
        cf.addConstructor(new Class[]{sourceClass}, null, "_source = $1;");
        String body = String.format("return _source.%s();", adapter.getReadMethod().getName());
        MethodSignature sig = new MethodSignature(propertyType, "_delegate", null, null);
        cf.addMethod(2, sig, body);
        String toString = String.format("<Shadow: property %s of %s>", propertyName, source);
        cf.proxyMethodsToDelegate(propertyType, "_delegate()", toString);
        Class shadowClass = cf.createClass();
        try {
            Constructor<?> cc = shadowClass.getConstructors()[0];
            Object instance = cc.newInstance(source);
            return propertyType.cast(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

