/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Map;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ClassFabUtils;

public class ClassFactoryClassPool
extends ClassPool {
    private final Set<ClassLoader> _allLoaders = CollectionFactory.newSet();
    private final Map<ClassLoader, ClassPath> _leafLoaders = CollectionFactory.newMap();

    public ClassFactoryClassPool(ClassLoader contextClassLoader) {
        super(null);
        this.addClassLoaderIfNeeded(contextClassLoader);
    }

    public Class importClass(Class clazz) {
        this.addClassLoaderIfNeeded(clazz.getClassLoader());
        while (true) {
            try {
                String name = ClassFabUtils.toJavaClassName(clazz);
                this.get(name);
            }
            catch (NotFoundException ex) {
                clazz = clazz.getSuperclass();
                continue;
            }
            break;
        }
        return clazz;
    }

    public synchronized void addClassLoaderIfNeeded(ClassLoader loader) {
        ClassLoader existingLeaf;
        Set<ClassLoader> leaves = this._leafLoaders.keySet();
        if (loader == null || leaves.contains(loader) || this._allLoaders.contains(loader)) {
            return;
        }
        for (existingLeaf = loader; existingLeaf != null && !leaves.contains(existingLeaf); existingLeaf = existingLeaf.getParent()) {
        }
        if (existingLeaf != null) {
            ClassPath priorPath = this._leafLoaders.get(existingLeaf);
            this.removeClassPath(priorPath);
            this._leafLoaders.remove(existingLeaf);
        }
        LoaderClassPath path = new LoaderClassPath(loader);
        this._leafLoaders.put(loader, (ClassPath)path);
        this.insertClassPath((ClassPath)path);
        for (ClassLoader l = loader; l != null; l = l.getParent()) {
            this._allLoaders.add(l);
        }
    }
}

