/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.internal.AbstractServiceCreator;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorServiceCreator
extends AbstractServiceCreator {
    private final Constructor _constructor;

    public ConstructorServiceCreator(ServiceBuilderResources resources, String creatorDescription, Constructor constructor) {
        super(resources, creatorDescription);
        this._constructor = constructor;
    }

    @Override
    public Object createObject() {
        Throwable failure;
        try {
            Object[] parameters = InternalUtils.calculateParametersForConstructor(this._constructor, this._resources, this.getParameterDefaultsWithConfigurations());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(IOCMessages.invokingConstructor(this._creatorDescription));
            }
            return this._constructor.newInstance(parameters);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        throw new RuntimeException(IOCMessages.constructorError(this._creatorDescription, this._serviceId, failure), failure);
    }

    private Map<Class, Object> getParameterDefaultsWithConfigurations() {
        return this.getParameterDefaultsWithConfiguration(this._constructor.getParameterTypes(), this._constructor.getGenericParameterTypes());
    }
}

