/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.util;

import java.util.Formatter;

public final class BodyBuilder {
    private static final int DEFAULT_LENGTH = 200;
    private final StringBuilder _buffer = new StringBuilder(200);
    private final Formatter _formatter = new Formatter(this._buffer);
    private static final String INDENT = "  ";
    private int _nestingDepth = 0;
    private boolean _atNewLine = true;

    public void clear() {
        this._nestingDepth = 0;
        this._atNewLine = true;
        this._buffer.setLength(0);
    }

    public void add(String format, Object ... args) {
        this.add(format, args, false);
    }

    public void addln(String format, Object ... args) {
        this.add(format, args, true);
    }

    private void add(String format, Object[] args, boolean newLine) {
        this.indent();
        this._formatter.format(format, args);
        if (newLine) {
            this.newline();
        }
    }

    private void newline() {
        this._buffer.append("\n");
        this._atNewLine = true;
    }

    public void begin() {
        if (!this._atNewLine) {
            this.newline();
        }
        this.indent();
        this._buffer.append("{");
        this.newline();
        ++this._nestingDepth;
    }

    public void end() {
        if (!this._atNewLine) {
            this.newline();
        }
        --this._nestingDepth;
        this.indent();
        this._buffer.append("}");
        this.newline();
    }

    private void indent() {
        if (this._atNewLine) {
            for (int i = 0; i < this._nestingDepth; ++i) {
                this._buffer.append(INDENT);
            }
            this._atNewLine = false;
        }
    }

    public String toString() {
        return this._buffer.toString();
    }
}

