/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.services;

import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.Coercion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoercionTuple<S, T> {
    private final Class<S> _sourceType;
    private final Class<T> _targetType;
    private final Coercion<S, T> _coercion;

    private String convert(Class type) {
        if (Void.TYPE.equals(type)) {
            return "null";
        }
        String name = ClassFabUtils.toJavaClassName(type);
        int dotx = name.lastIndexOf(46);
        if (dotx > 0 && name.substring(0, dotx).equals("java.lang")) {
            return name.substring(dotx + 1);
        }
        return name;
    }

    public CoercionTuple(Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        this(sourceType, targetType, coercion, true);
    }

    public CoercionTuple(Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion, boolean wrap) {
        Defense.notNull(sourceType, "sourceType");
        Defense.notNull(targetType, "targetType");
        Defense.notNull(coercion, "coercion");
        this._sourceType = sourceType;
        this._targetType = targetType;
        this._coercion = wrap ? new CoercionWrapper(coercion) : coercion;
    }

    public String toString() {
        return this._coercion.toString();
    }

    public Coercion<S, T> getCoercion() {
        return this._coercion;
    }

    public Class<S> getSourceType() {
        return this._sourceType;
    }

    public Class<T> getTargetType() {
        return this._targetType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CoercionWrapper<WS, WT>
    implements Coercion<WS, WT> {
        private final Coercion<WS, WT> _coercion;

        public CoercionWrapper(Coercion<WS, WT> coercion) {
            this._coercion = coercion;
        }

        @Override
        public WT coerce(WS input) {
            return this._coercion.coerce(input);
        }

        public String toString() {
            return String.format("%s --> %s", CoercionTuple.this.convert(CoercionTuple.this._sourceType), CoercionTuple.this.convert(CoercionTuple.this._targetType));
        }
    }
}

