/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedNameGenerator
implements Iterator<String>,
Iterable<String> {
    private final int _baseNameLength;
    private final String _suffix;
    private final StringBuilder _builder;
    private final String _language;
    private final String _country;
    private final String _variant;
    private int _state;
    private int _prevState;
    private static final int INITIAL = 0;
    private static final int LCV = 1;
    private static final int LC = 2;
    private static final int LV = 3;
    private static final int L = 4;
    private static final int BARE = 5;
    private static final int EXHAUSTED = 6;

    public LocalizedNameGenerator(String path, Locale locale) {
        int dotx = path.lastIndexOf(46);
        if (dotx == -1) {
            dotx = path.length();
        }
        String baseName = path.substring(0, dotx);
        this._suffix = path.substring(dotx);
        this._baseNameLength = dotx;
        this._language = locale.getLanguage();
        this._country = locale.getCountry();
        this._variant = locale.getVariant();
        this._state = 0;
        this._prevState = 0;
        this._builder = new StringBuilder(baseName);
        this.advance();
    }

    private void advance() {
        this._prevState = this._state;
        block6: while (this._state != 6) {
            ++this._state;
            switch (this._state) {
                case 1: {
                    if (InternalUtils.isBlank(this._variant)) continue block6;
                    return;
                }
                case 2: {
                    if (InternalUtils.isBlank(this._country)) continue block6;
                    return;
                }
                case 3: {
                    if (InternalUtils.isBlank(this._variant) || InternalUtils.isBlank(this._country)) continue block6;
                    return;
                }
                case 4: {
                    if (InternalUtils.isBlank(this._language)) continue block6;
                    return;
                }
            }
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this._state != 6;
    }

    @Override
    public String next() {
        if (this._state == 6) {
            throw new NoSuchElementException();
        }
        String result = this.build();
        this.advance();
        return result;
    }

    private String build() {
        this._builder.setLength(this._baseNameLength);
        if (this._state == 2 || this._state == 1 || this._state == 4) {
            this._builder.append('_');
            this._builder.append(this._language);
        }
        if (this._state == 2 || this._state == 1 || this._state == 3) {
            this._builder.append('_');
            if (this._state != 3) {
                this._builder.append(this._country);
            }
        }
        if (this._state == 3 || this._state == 1) {
            this._builder.append('_');
            this._builder.append(this._variant);
        }
        if (this._suffix != null) {
            this._builder.append(this._suffix);
        }
        return this._builder.toString();
    }

    public Locale getCurrentLocale() {
        switch (this._prevState) {
            case 1: {
                return new Locale(this._language, this._country, this._variant);
            }
            case 2: {
                return new Locale(this._language, this._country, "");
            }
            case 3: {
                return new Locale(this._language, "", this._variant);
            }
            case 4: {
                return new Locale(this._language, "", "");
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

