/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.net.URL;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.AbstractResource;
import org.apache.tapestry.ioc.internal.util.Defense;

public final class ClasspathResource
extends AbstractResource {
    private final ClassLoader _classLoader;
    private URL _url;

    public ClasspathResource(String path) {
        this(Thread.currentThread().getContextClassLoader(), path);
    }

    public ClasspathResource(ClassLoader classLoader, String path) {
        super(path);
        Defense.notNull(classLoader, "classLoader");
        this._classLoader = classLoader;
    }

    protected Resource newResource(String path) {
        return new ClasspathResource(this._classLoader, path);
    }

    public synchronized URL toURL() {
        if (this._url == null) {
            this._url = this._classLoader.getResource(this.getPath());
        }
        return this._url;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClasspathResource other = (ClasspathResource)obj;
        return other._classLoader == this._classLoader && other.getPath().equals(this.getPath());
    }

    public int hashCode() {
        return 0xE3 ^ this.getPath().hashCode();
    }

    public String toString() {
        return "classpath:" + this.getPath();
    }
}

