/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.security.ProtectionDomain;
import javassist.CtClass;
import javassist.NotFoundException;
import org.apache.tapestry.ioc.internal.services.ClassFactoryClassPool;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.services.ClassFabUtils;

class CtClassSource {
    private final ClassFactoryClassPool _pool;
    private final ClassLoader _loader;
    private final ProtectionDomain _domain = this.getClass().getProtectionDomain();
    private int _createdClassCount = 0;
    private static final String WRITE_DIR = System.getProperty("javassist-write-dir");

    public synchronized int getCreatedClassCount() {
        return this._createdClassCount;
    }

    public CtClassSource(ClassFactoryClassPool pool, ClassLoader loader) {
        this._pool = pool;
        this._loader = loader;
    }

    public CtClass getCtClass(Class searchClass) {
        ClassLoader loader = searchClass.getClassLoader();
        this._pool.addClassLoaderIfNeeded(loader);
        String name = ClassFabUtils.toJavaClassName(searchClass);
        try {
            return this._pool.get(name);
        }
        catch (NotFoundException ex) {
            throw new RuntimeException(ServiceMessages.unableToLookupClass(name, ex), ex);
        }
    }

    public synchronized CtClass newClass(String name, Class superClass) {
        CtClass ctSuperClass = this.getCtClass(superClass);
        return this._pool.makeClass(name, ctSuperClass);
    }

    public synchronized Class createClass(CtClass ctClass) {
        if (WRITE_DIR != null) {
            this.writeClass(ctClass);
        }
        try {
            Class result = this._pool.toClass(ctClass, this._loader, this._domain);
            ++this._createdClassCount;
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ServiceMessages.unableToWriteClass(ctClass, ex), ex);
        }
    }

    private void writeClass(CtClass ctClass) {
        try {
            boolean pruning = ctClass.stopPruning(true);
            ctClass.writeFile(WRITE_DIR);
            ctClass.defrost();
            ctClass.stopPruning(pruning);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

