/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.internal.services.PropertyAdapterImpl;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.GenericsUtils;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry.ioc.services.PropertyAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPropertyAdapterImpl
implements ClassPropertyAdapter {
    private final Map<String, PropertyAdapter> _adapters = CollectionFactory.newCaseInsensitiveMap();
    private final Class _beanType;

    public ClassPropertyAdapterImpl(Class beanType, List<PropertyDescriptor> descriptors) {
        this._beanType = beanType;
        for (PropertyDescriptor pd : descriptors) {
            if (pd.getPropertyType() == null) continue;
            Method readMethod = pd.getReadMethod();
            Class propertyType = readMethod == null ? pd.getPropertyType() : GenericsUtils.extractGenericReturnType(beanType, readMethod);
            PropertyAdapterImpl pa = new PropertyAdapterImpl(pd.getName(), propertyType, readMethod, pd.getWriteMethod());
            this._adapters.put(pa.getName(), pa);
        }
    }

    @Override
    public Class getBeanType() {
        return this._beanType;
    }

    public String toString() {
        String names = InternalUtils.joinSorted(this._adapters.keySet());
        return String.format("<ClassPropertyAdaptor %s : %s>", this._beanType.getName(), names);
    }

    @Override
    public List<String> getPropertyNames() {
        return InternalUtils.sortedKeys(this._adapters);
    }

    @Override
    public PropertyAdapter getPropertyAdapter(String name) {
        return this._adapters.get(name);
    }

    @Override
    public Object get(Object instance, String propertyName) {
        return this.adaptorFor(propertyName).get(instance);
    }

    @Override
    public void set(Object instance, String propertyName, Object value) {
        this.adaptorFor(propertyName).set(instance, value);
    }

    private PropertyAdapter adaptorFor(String name) {
        PropertyAdapter pa = this._adapters.get(name);
        if (pa == null) {
            throw new IllegalArgumentException(ServiceMessages.noSuchProperty(this._beanType, name));
        }
        return pa;
    }
}

