/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.internal.services.ClassFabImpl;
import org.apache.tapestry.ioc.internal.services.ClassFactoryClassPool;
import org.apache.tapestry.ioc.internal.services.CtClassSource;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.services.StringLocation;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFactoryImpl
implements ClassFactory {
    private final Logger _logger;
    private final ClassFactoryClassPool _pool;
    private final CtClassSource _classSource;
    private final ClassLoader _loader;

    public ClassFactoryImpl(ClassLoader classLoader) {
        this(classLoader, LoggerFactory.getLogger(ClassFactoryImpl.class));
    }

    public ClassFactoryImpl() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassFactoryImpl(ClassLoader classLoader, Logger log) {
        this(classLoader, new ClassFactoryClassPool(classLoader), log);
    }

    public ClassFactoryImpl(ClassLoader classLoader, ClassFactoryClassPool pool, Logger logger) {
        this._loader = classLoader;
        this._pool = pool;
        this._classSource = new CtClassSource(this._pool, classLoader);
        this._logger = logger;
    }

    public ClassFab newClass(Class serviceInterface) {
        String name = ClassFabUtils.generateClassName(serviceInterface);
        ClassFab cf = this.newClass(name, Object.class);
        cf.addInterface(serviceInterface);
        return cf;
    }

    public ClassFab newClass(String name, Class superClass) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(String.format("Create ClassFab for %s (extends %s)", name, superClass.getName()));
        }
        try {
            CtClass ctNewClass = this._classSource.newClass(name, superClass);
            return new ClassFabImpl(this._classSource, ctNewClass, this._logger);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToCreateClass(name, superClass, ex), ex);
        }
    }

    public Class importClass(Class clazz) {
        return this._pool.importClass(clazz);
    }

    public int getCreatedClassCount() {
        return this._classSource.getCreatedClassCount();
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public Location getMethodLocation(Method method) {
        Defense.notNull(method, "method");
        Class<?> declaringClass = method.getDeclaringClass();
        Class effectiveClass = this.importClass(declaringClass);
        CtClass ctClass = this._classSource.getCtClass(effectiveClass);
        StringBuilder builder = new StringBuilder("(");
        for (Class<?> parameterType : method.getParameterTypes()) {
            builder.append(ClassFabUtils.getTypeCode(parameterType));
        }
        builder.append(")");
        builder.append(ClassFabUtils.getTypeCode(method.getReturnType()));
        try {
            CtMethod ctMethod = ctClass.getMethod(method.getName(), builder.toString());
            int lineNumber = ctMethod.getMethodInfo().getLineNumber(0);
            String sourceFile = ctMethod.getDeclaringClass().getClassFile2().getSourceFile();
            String description = String.format("%s (at %s:%d)", InternalUtils.asString(method), sourceFile, lineNumber);
            return new StringLocation(description, lineNumber);
        }
        catch (Exception ex) {
            return new StringLocation(InternalUtils.asString(method), 0);
        }
    }

    public Location getConstructorLocation(Constructor constructor) {
        Defense.notNull(constructor, "constructor");
        StringBuilder builder = new StringBuilder();
        Class declaringClass = constructor.getDeclaringClass();
        builder.append(declaringClass.getName());
        builder.append("(");
        CtClass ctClass = this._classSource.getCtClass(declaringClass);
        StringBuilder descripton = new StringBuilder("(");
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(parameterType.getSimpleName());
            descripton.append(ClassFabUtils.getTypeCode(parameterType));
        }
        builder.append(")");
        descripton.append(")V");
        int lineNumber = 0;
        try {
            CtConstructor ctConstructor = ctClass.getConstructor(descripton.toString());
            lineNumber = ctConstructor.getMethodInfo().getLineNumber(0);
            String sourceFile = ctConstructor.getDeclaringClass().getClassFile2().getSourceFile();
            builder.append(String.format(" (at %s:%d)", sourceFile, lineNumber));
        }
        catch (Exception ex) {
            // empty catch block
        }
        return new StringLocation(builder.toString(), lineNumber);
    }
}

