/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Set;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ServiceBinder;
import org.apache.tapestry.ioc.ServiceBindingOptions;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.annotations.EagerLoad;
import org.apache.tapestry.ioc.annotations.Marker;
import org.apache.tapestry.ioc.annotations.Scope;
import org.apache.tapestry.ioc.internal.ConstructorServiceCreator;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.ObjectCreatorSource;
import org.apache.tapestry.ioc.internal.ServiceDefAccumulator;
import org.apache.tapestry.ioc.internal.ServiceDefImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.services.ClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBinderImpl
implements ServiceBinder,
ServiceBindingOptions {
    private final OneShotLock _lock = new OneShotLock();
    private final ServiceDefAccumulator _accumulator;
    private final ClassFactory _classFactory;
    private final Set<Class> _defaultMarkers;
    private String _serviceId;
    private Class _serviceInterface;
    private final Set<Class> _markers = CollectionFactory.newSet();
    private Class _serviceImplementation;
    private boolean _eagerLoad;
    private String _scope;

    public ServiceBinderImpl(ServiceDefAccumulator accumulator, ClassFactory classFactory, Set<Class> defaultMarkers) {
        this._accumulator = accumulator;
        this._classFactory = classFactory;
        this._defaultMarkers = defaultMarkers;
    }

    public void finish() {
        this._lock.lock();
        this.flush();
    }

    protected void flush() {
        if (this._serviceInterface == null) {
            return;
        }
        final Constructor constructor = this.findConstructor();
        ObjectCreatorSource source = new ObjectCreatorSource(){

            public ObjectCreator constructCreator(ServiceBuilderResources resources) {
                return new ConstructorServiceCreator(resources, this.getDescription(), constructor);
            }

            public String getDescription() {
                return ServiceBinderImpl.this._classFactory.getConstructorLocation(constructor).toString();
            }
        };
        Set<Class> markers = CollectionFactory.newSet(this._defaultMarkers);
        markers.addAll(this._markers);
        ServiceDefImpl serviceDef = new ServiceDefImpl(this._serviceInterface, this._serviceId, markers, this._scope, this._eagerLoad, source);
        this._accumulator.addServiceDef(serviceDef);
        this._serviceId = null;
        this._serviceInterface = null;
        this._markers.clear();
        this._serviceImplementation = null;
        this._eagerLoad = false;
        this._scope = null;
    }

    private Constructor findConstructor() {
        Constructor result = InternalUtils.findAutobuildConstructor(this._serviceImplementation);
        if (result == null) {
            throw new RuntimeException(IOCMessages.noConstructor(this._serviceImplementation, this._serviceId));
        }
        return result;
    }

    @Override
    public <T> ServiceBindingOptions bind(Class<T> implementationClass) {
        return this.bind(implementationClass, implementationClass);
    }

    @Override
    public <T> ServiceBindingOptions bind(Class<T> serviceInterface, Class<? extends T> serviceImplementation) {
        Defense.notNull(serviceInterface, "serviceIterface");
        Defense.notNull(serviceImplementation, "serviceImplementation");
        this._lock.check();
        this.flush();
        this._serviceInterface = serviceInterface;
        this._serviceImplementation = serviceImplementation;
        this._eagerLoad = serviceImplementation.getAnnotation(EagerLoad.class) != null;
        this._serviceId = serviceInterface.getSimpleName();
        Scope scope = serviceImplementation.getAnnotation(Scope.class);
        this._scope = scope != null ? scope.value() : "singleton";
        Marker marker = serviceImplementation.getAnnotation(Marker.class);
        if (marker != null) {
            InternalUtils.validateMarkerAnnotations(marker.value());
            this._markers.addAll(Arrays.asList(marker.value()));
        }
        return this;
    }

    @Override
    public ServiceBindingOptions eagerLoad() {
        this._lock.check();
        this._eagerLoad = true;
        return this;
    }

    @Override
    public ServiceBindingOptions withId(String id) {
        Defense.notBlank(id, "id");
        this._lock.check();
        this._serviceId = id;
        return this;
    }

    @Override
    public ServiceBindingOptions scope(String scope) {
        Defense.notBlank(scope, "scope");
        this._lock.check();
        this._scope = scope;
        return this;
    }

    @Override
    public <T extends Annotation> ServiceBindingOptions withMarker(Class<T> ... marker) {
        this._lock.check();
        InternalUtils.validateMarkerAnnotations(marker);
        this._markers.addAll(Arrays.asList(marker));
        return this;
    }
}

