/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.ServiceBinder;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.annotations.EagerLoad;
import org.apache.tapestry.ioc.annotations.Marker;
import org.apache.tapestry.ioc.annotations.Match;
import org.apache.tapestry.ioc.annotations.Order;
import org.apache.tapestry.ioc.annotations.Scope;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.def.DecoratorDef;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.ConfigurationType;
import org.apache.tapestry.ioc.internal.ContributionDefImpl;
import org.apache.tapestry.ioc.internal.DecoratorDefImpl;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.ObjectCreatorSource;
import org.apache.tapestry.ioc.internal.ServiceBinderImpl;
import org.apache.tapestry.ioc.internal.ServiceBuilderMethodInvoker;
import org.apache.tapestry.ioc.internal.ServiceDefAccumulator;
import org.apache.tapestry.ioc.internal.ServiceDefImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleDefImpl
implements ModuleDef,
ServiceDefAccumulator {
    private static final String BUILD_METHOD_NAME_PREFIX = "build";
    private static final String DECORATE_METHOD_NAME_PREFIX = "decorate";
    private static final String CONTRIBUTE_METHOD_NAME_PREFIX = "contribute";
    private final Class _builderClass;
    private final Logger _logger;
    private final ClassFactory _classFactory;
    private final Map<String, ServiceDef> _serviceDefs = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, DecoratorDef> _decoratorDefs = CollectionFactory.newCaseInsensitiveMap();
    private final Set<ContributionDef> _contributionDefs = CollectionFactory.newSet();
    private static final Map<Class, ConfigurationType> PARAMETER_TYPE_TO_CONFIGURATION_TYPE = CollectionFactory.newMap();
    private final Set<Class> _defaultMarkers = CollectionFactory.newSet();

    public DefaultModuleDefImpl(Class<?> builderClass, Logger logger, ClassFactory classFactory) {
        this._builderClass = builderClass;
        this._logger = logger;
        this._classFactory = classFactory;
        Marker annotation = builderClass.getAnnotation(Marker.class);
        if (annotation != null) {
            InternalUtils.validateMarkerAnnotations(annotation.value());
            this._defaultMarkers.addAll(Arrays.asList(annotation.value()));
        }
        this.grind();
        this.bind();
    }

    public String toString() {
        return String.format("ModuleDef[%s %s]", this._builderClass.getName(), InternalUtils.joinSorted(this._serviceDefs.keySet()));
    }

    @Override
    public Class getBuilderClass() {
        return this._builderClass;
    }

    @Override
    public Set<String> getServiceIds() {
        return this._serviceDefs.keySet();
    }

    @Override
    public ServiceDef getServiceDef(String serviceId) {
        return this._serviceDefs.get(serviceId);
    }

    private void grind() {
        Method[] methods = this._builderClass.getMethods();
        Comparator<Method> c = new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int result = o1.getName().compareTo(o2.getName());
                if (result == 0) {
                    result = o2.getParameterTypes().length - o1.getParameterTypes().length;
                }
                return result;
            }
        };
        Arrays.sort(methods, c);
        for (Method m : methods) {
            String name = m.getName();
            if (name.startsWith(BUILD_METHOD_NAME_PREFIX)) {
                this.addServiceDef(m);
                continue;
            }
            if (name.startsWith(DECORATE_METHOD_NAME_PREFIX)) {
                this.addDecoratorDef(m);
                continue;
            }
            if (!name.startsWith(CONTRIBUTE_METHOD_NAME_PREFIX)) continue;
            this.addContributionDef(m);
        }
    }

    private void addContributionDef(Method method) {
        String serviceId = this.stripMethodPrefix(method, CONTRIBUTE_METHOD_NAME_PREFIX);
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            this._logger.warn(IOCMessages.contributionWrongReturnType(method));
        }
        ConfigurationType type = null;
        for (Class<?> parameterType : method.getParameterTypes()) {
            ConfigurationType thisParameter = PARAMETER_TYPE_TO_CONFIGURATION_TYPE.get(parameterType);
            if (thisParameter == null) continue;
            if (type != null) {
                this._logger.warn(IOCMessages.tooManyContributionParameters(method));
                return;
            }
            type = thisParameter;
        }
        if (type == null) {
            this._logger.warn(IOCMessages.noContributionParameter(method));
            return;
        }
        ContributionDefImpl def = new ContributionDefImpl(serviceId, method, this._classFactory);
        this._contributionDefs.add(def);
    }

    private void addDecoratorDef(Method method) {
        String[] stringArray;
        String[] constraints;
        String decoratorId = this.stripMethodPrefix(method, DECORATE_METHOD_NAME_PREFIX);
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive() || returnType.isArray()) {
            this._logger.warn(IOCMessages.decoratorMethodWrongReturnType(method));
            return;
        }
        if (!this.methodContainsObjectParameter(method)) {
            this._logger.warn(IOCMessages.decoratorMethodNeedsDelegateParameter(method));
            return;
        }
        Order orderAnnotation = method.getAnnotation(Order.class);
        Match match = method.getAnnotation(Match.class);
        String[] stringArray2 = constraints = orderAnnotation != null ? orderAnnotation.value() : null;
        if (match == null) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = decoratorId;
        } else {
            stringArray = match.value();
        }
        String[] patterns = stringArray;
        DecoratorDefImpl def = new DecoratorDefImpl(decoratorId, method, patterns, constraints, this._classFactory);
        this._decoratorDefs.put(decoratorId, def);
    }

    private boolean methodContainsObjectParameter(Method method) {
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (!parameterType.equals(Object.class)) continue;
            return true;
        }
        return false;
    }

    private String stripMethodPrefix(Method method, String prefix) {
        return method.getName().substring(prefix.length());
    }

    private void addServiceDef(final Method method) {
        Class<?> returnType;
        String serviceId = this.stripMethodPrefix(method, BUILD_METHOD_NAME_PREFIX);
        if (serviceId.equals("")) {
            serviceId = method.getReturnType().getSimpleName();
        }
        if ((returnType = method.getReturnType()).isPrimitive() || returnType.isArray()) {
            this._logger.warn(IOCMessages.buildMethodWrongReturnType(method));
            return;
        }
        String scope = this.extractServiceScope(method);
        boolean eagerLoad = method.isAnnotationPresent(EagerLoad.class);
        ObjectCreatorSource source = new ObjectCreatorSource(){

            public ObjectCreator constructCreator(ServiceBuilderResources resources) {
                return new ServiceBuilderMethodInvoker(resources, this.getDescription(), method);
            }

            public String getDescription() {
                return InternalUtils.asString(method, DefaultModuleDefImpl.this._classFactory);
            }
        };
        Set<Class> markers = CollectionFactory.newSet(this._defaultMarkers);
        markers.addAll(this.extractMarkers(method));
        ServiceDefImpl serviceDef = new ServiceDefImpl(returnType, serviceId, markers, scope, eagerLoad, source);
        this.addServiceDef(serviceDef);
    }

    private Collection<Class> extractMarkers(Method method) {
        Marker annotation = method.getAnnotation(Marker.class);
        if (annotation == null) {
            return Collections.emptyList();
        }
        return CollectionFactory.newList(annotation.value());
    }

    @Override
    public void addServiceDef(ServiceDef serviceDef) {
        String serviceId = serviceDef.getServiceId();
        ServiceDef existing = this._serviceDefs.get(serviceId);
        if (existing != null) {
            this._logger.warn(IOCMessages.buildMethodConflict(serviceDef.toString(), existing.toString()));
            return;
        }
        this._serviceDefs.put(serviceId, serviceDef);
    }

    private String extractServiceScope(Method method) {
        Scope scope = method.getAnnotation(Scope.class);
        return scope != null ? scope.value() : "singleton";
    }

    @Override
    public Set<DecoratorDef> getDecoratorDefs() {
        return CollectionFactory.newSet(this._decoratorDefs.values());
    }

    @Override
    public Set<ContributionDef> getContributionDefs() {
        return this._contributionDefs;
    }

    @Override
    public String getLoggerName() {
        return this._builderClass.getName();
    }

    private void bind() {
        Throwable failure;
        Method bindMethod = null;
        try {
            bindMethod = this._builderClass.getMethod("bind", ServiceBinder.class);
            if (!Modifier.isStatic(bindMethod.getModifiers())) {
                this._logger.error(IOCMessages.bindMethodMustBeStatic(InternalUtils.asString(bindMethod, this._classFactory)));
                return;
            }
            ServiceBinderImpl binder = new ServiceBinderImpl(this, this._classFactory, this._defaultMarkers);
            bindMethod.invoke(null, binder);
            binder.finish();
            return;
        }
        catch (NoSuchMethodException ex) {
            return;
        }
        catch (IllegalArgumentException ex) {
            failure = ex;
        }
        catch (IllegalAccessException ex) {
            failure = ex;
        }
        catch (InvocationTargetException ex) {
            failure = ex.getTargetException();
        }
        String methodId = InternalUtils.asString(bindMethod, this._classFactory);
        throw new RuntimeException(IOCMessages.errorInBindMethod(methodId, failure), failure);
    }

    static {
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Configuration.class, ConfigurationType.UNORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(OrderedConfiguration.class, ConfigurationType.ORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(MappedConfiguration.class, ConfigurationType.MAPPED);
    }
}

