/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.collation.ICUCollationKeyFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class ICUCollationKeyFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private Collator collator;

    public void inform(ResourceLoader loader) {
        String custom = (String)this.args.get("custom");
        String localeID = (String)this.args.get("locale");
        String strength = (String)this.args.get("strength");
        String decomposition = (String)this.args.get("decomposition");
        if (custom == null && localeID == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Either custom or locale is required.");
        }
        if (custom != null && localeID != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot specify both locale and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        this.collator = localeID != null ? this.createFromLocale(localeID) : this.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                this.collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                this.collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                this.collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("quaternary")) {
                this.collator.setStrength(3);
            } else if (strength.equalsIgnoreCase("identical")) {
                this.collator.setStrength(15);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                this.collator.setDecomposition(16);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                this.collator.setDecomposition(17);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid decomposition: " + decomposition);
            }
        }
    }

    public TokenStream create(TokenStream input) {
        return new ICUCollationKeyFilter(input, this.collator);
    }

    private Collator createFromLocale(String localeID) {
        return Collator.getInstance((ULocale)new ULocale(localeID));
    }

    private Collator createFromRules(String fileName, ResourceLoader loader) {
        InputStream input = null;
        try {
            input = loader.openResource(fileName);
            String rules = IOUtils.toString((InputStream)input, (String)"UTF-8");
            RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(rules);
            return ruleBasedCollator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }
}

