/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.UrlValidationStatus;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;

public class JsServlet
extends InjectedServlet {
    private FeatureRegistry registry;
    private UrlGenerator urlGenerator;

    @Inject
    public void setRegistry(FeatureRegistry registry) {
        this.registry = registry;
    }

    @Inject
    public void setUrlGenerator(UrlGenerator urlGenerator) {
        this.urlGenerator = urlGenerator;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UrlValidationStatus vstatus = this.urlGenerator.validateJsUrl(req.getRequestURL().append('?').append(req.getQueryString()).toString());
        if (req.getHeader("If-Modified-Since") != null && vstatus == UrlValidationStatus.VALID_VERSIONED) {
            resp.setStatus(304);
            return;
        }
        String uri = req.getRequestURI();
        String resourceName = uri.substring(uri.lastIndexOf(47) + 1);
        if (resourceName.endsWith(".js")) {
            resourceName = resourceName.substring(0, resourceName.length() - ".js".length());
        }
        ImmutableSet needed = ImmutableSet.of((Object[])resourceName.split(":"));
        String debugStr = req.getParameter("debug");
        String containerParam = req.getParameter("container");
        String containerStr = req.getParameter("c");
        boolean debug = "1".equals(debugStr);
        final RenderingContext context = "1".equals(containerStr) ? RenderingContext.CONTAINER : RenderingContext.GADGET;
        final String container = containerParam != null ? containerParam : "default";
        GadgetContext ctx = new GadgetContext(){

            public RenderingContext getRenderingContext() {
                return context;
            }

            public String getContainer() {
                return container;
            }
        };
        List<FeatureResource> resources = this.registry.getFeatureResources(ctx, (Collection<String>)needed, null);
        StringBuilder jsData = new StringBuilder();
        boolean isProxyCacheable = true;
        for (FeatureResource featureResource : resources) {
            String content;
            String string = content = debug ? featureResource.getDebugContent() : featureResource.getContent();
            if (!featureResource.isExternal()) {
                jsData.append(content);
            } else {
                jsData.append("document.write('<script src=\"").append(content).append("\"></script>')");
            }
            isProxyCacheable = isProxyCacheable && featureResource.isProxyCacheable();
            jsData.append(";\n");
        }
        if (jsData.length() == 0) {
            resp.setStatus(404);
            return;
        }
        switch (vstatus) {
            case VALID_VERSIONED: {
                HttpUtil.setCachingHeaders((HttpServletResponse)resp, (!isProxyCacheable ? 1 : 0) != 0);
                break;
            }
            case VALID_UNVERSIONED: {
                HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)3600, (!isProxyCacheable ? 1 : 0) != 0);
                break;
            }
            case INVALID: {
                HttpUtil.setNoCache((HttpServletResponse)resp);
            }
        }
        resp.setContentType("text/javascript; charset=utf-8");
        byte[] response = jsData.toString().getBytes("UTF-8");
        resp.setContentLength(response.length);
        resp.getOutputStream().write(response);
    }
}

