/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter;

import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlNode;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.MergeStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.delete.DeleteStatementConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.explain.ExplainStatementConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.insert.InsertStatementConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.merge.MergeStatementConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.select.SelectStatementConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.update.UpdateStatementConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.exception.OptimizationSQLNodeConvertException;

public final class SQLNodeConverterEngine {
    public static SqlNode convert(SQLStatement sqlStatement) {
        Optional<Object> result = Optional.empty();
        if (sqlStatement instanceof DMLStatement) {
            result = SQLNodeConverterEngine.convert((DMLStatement)sqlStatement);
        } else if (sqlStatement instanceof DALStatement) {
            result = SQLNodeConverterEngine.convert((DALStatement)sqlStatement);
        }
        return (SqlNode)result.orElseThrow(() -> new OptimizationSQLNodeConvertException(sqlStatement));
    }

    private static Optional<SqlNode> convert(DMLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            return Optional.of(new SelectStatementConverter().convert((SelectStatement)sqlStatement));
        }
        if (sqlStatement instanceof DeleteStatement) {
            return Optional.of(new DeleteStatementConverter().convert((DeleteStatement)sqlStatement));
        }
        if (sqlStatement instanceof UpdateStatement) {
            return Optional.of(new UpdateStatementConverter().convert((UpdateStatement)sqlStatement));
        }
        if (sqlStatement instanceof InsertStatement) {
            return Optional.of(new InsertStatementConverter().convert((InsertStatement)sqlStatement));
        }
        if (sqlStatement instanceof MergeStatement) {
            return Optional.of(new MergeStatementConverter().convert((MergeStatement)sqlStatement));
        }
        return Optional.empty();
    }

    private static Optional<SqlNode> convert(DALStatement sqlStatement) {
        if (sqlStatement instanceof ExplainStatement) {
            return Optional.of(new ExplainStatementConverter().convert((ExplainStatement)sqlStatement));
        }
        return Optional.empty();
    }

    @Generated
    private SQLNodeConverterEngine() {
    }
}

