/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.type;

import java.util.LinkedList;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.PostgreSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.prepare.PrepareStatementQuerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLCallStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLCheckpointStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLCopyStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLDoStatement;

public final class PostgreSQLDMLStatementVisitor
extends PostgreSQLStatementVisitor
implements DMLStatementVisitor {
    @Override
    public ASTNode visitCall(PostgreSQLStatementParser.CallContext ctx) {
        PostgreSQLCallStatement result = new PostgreSQLCallStatement();
        result.setProcedureName(((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
        if (null != ctx.callArguments()) {
            LinkedList<ExpressionSegment> params = new LinkedList<ExpressionSegment>();
            for (PostgreSQLStatementParser.CallArgumentContext each : ctx.callArguments().callArgument()) {
                params.add((ExpressionSegment)this.visit((ParseTree)each));
            }
            result.getParameters().addAll(params);
        }
        return result;
    }

    @Override
    public ASTNode visitCallArgument(PostgreSQLStatementParser.CallArgumentContext ctx) {
        if (null == ctx.positionalNotation()) {
            String text = ctx.namedNotation().start.getInputStream().getText(new Interval(ctx.namedNotation().start.getStartIndex(), ctx.namedNotation().stop.getStopIndex()));
            return new CommonExpressionSegment(ctx.namedNotation().getStart().getStartIndex(), ctx.namedNotation().getStop().getStopIndex(), text);
        }
        return (ASTNode)this.visit((ParseTree)ctx.positionalNotation().aExpr());
    }

    @Override
    public ASTNode visitDoStatement(PostgreSQLStatementParser.DoStatementContext ctx) {
        return new PostgreSQLDoStatement();
    }

    @Override
    public ASTNode visitCopy(PostgreSQLStatementParser.CopyContext ctx) {
        if (null != ctx.copyWithTableOrQuery()) {
            return (ASTNode)this.visit((ParseTree)ctx.copyWithTableOrQuery());
        }
        if (null != ctx.copyWithTableOrQueryBinaryCsv()) {
            return (ASTNode)this.visit((ParseTree)ctx.copyWithTableOrQueryBinaryCsv());
        }
        return (ASTNode)this.visit((ParseTree)ctx.copyWithTableBinary());
    }

    @Override
    public ASTNode visitCopyWithTableOrQuery(PostgreSQLStatementParser.CopyWithTableOrQueryContext ctx) {
        PostgreSQLCopyStatement result = new PostgreSQLCopyStatement();
        if (null != ctx.qualifiedName()) {
            result.setTableSegment((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
            if (null != ctx.columnNames()) {
                result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.columnNames())).getValue());
            }
        }
        if (null != ctx.preparableStmt()) {
            result.setPrepareStatementQuerySegment(this.extractPrepareStatementQuerySegmentFromPreparableStmt(ctx.preparableStmt()));
        }
        return result;
    }

    private PrepareStatementQuerySegment extractPrepareStatementQuerySegmentFromPreparableStmt(PostgreSQLStatementParser.PreparableStmtContext ctx) {
        PrepareStatementQuerySegment result = new PrepareStatementQuerySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.select()) {
            result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        } else if (null != ctx.insert()) {
            result.setInsert((InsertStatement)this.visit((ParseTree)ctx.insert()));
        } else if (null != ctx.update()) {
            result.setUpdate((UpdateStatement)this.visit((ParseTree)ctx.update()));
        } else {
            result.setDelete((DeleteStatement)this.visit((ParseTree)ctx.delete()));
        }
        return result;
    }

    @Override
    public ASTNode visitCopyWithTableOrQueryBinaryCsv(PostgreSQLStatementParser.CopyWithTableOrQueryBinaryCsvContext ctx) {
        PostgreSQLCopyStatement result = new PostgreSQLCopyStatement();
        if (null != ctx.qualifiedName()) {
            result.setTableSegment((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
            if (null != ctx.columnNames()) {
                result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.columnNames())).getValue());
            }
        }
        if (null != ctx.preparableStmt()) {
            result.setPrepareStatementQuerySegment(this.extractPrepareStatementQuerySegmentFromPreparableStmt(ctx.preparableStmt()));
        }
        return result;
    }

    @Override
    public ASTNode visitCopyWithTableBinary(PostgreSQLStatementParser.CopyWithTableBinaryContext ctx) {
        PostgreSQLCopyStatement result = new PostgreSQLCopyStatement();
        if (null != ctx.qualifiedName()) {
            result.setTableSegment((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCheckpoint(PostgreSQLStatementParser.CheckpointContext ctx) {
        return new PostgreSQLCheckpointStatement();
    }

    @Override
    public ASTNode visitReturningClause(PostgreSQLStatementParser.ReturningClauseContext ctx) {
        return new ReturningSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ProjectionsSegment)this.visit((ParseTree)ctx.targetList()));
    }
}

