/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.TableType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereConstraint;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;

public final class ShardingSphereTable {
    private final String name;
    private final Map<String, ShardingSphereColumn> columns;
    private final Map<String, ShardingSphereIndex> indexes;
    private final Map<String, ShardingSphereConstraint> constraints;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> visibleColumns = new ArrayList<String>();
    private final List<String> primaryKeyColumns = new ArrayList<String>();
    private final TableType type;

    public ShardingSphereTable() {
        this("", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), TableType.TABLE);
    }

    public ShardingSphereTable(String name, Collection<ShardingSphereColumn> columns, Collection<ShardingSphereIndex> indexes, Collection<ShardingSphereConstraint> constraints) {
        this.name = name;
        this.columns = this.createColumns(columns);
        this.indexes = this.createIndexes(indexes);
        this.constraints = this.createConstraints(constraints);
        this.type = TableType.TABLE;
    }

    public ShardingSphereTable(String name, Collection<ShardingSphereColumn> columns, Collection<ShardingSphereIndex> indexes, Collection<ShardingSphereConstraint> constraints, TableType type) {
        this.name = name;
        this.columns = this.createColumns(columns);
        this.indexes = this.createIndexes(indexes);
        this.constraints = this.createConstraints(constraints);
        this.type = type;
    }

    private Map<String, ShardingSphereColumn> createColumns(Collection<ShardingSphereColumn> columns) {
        LinkedHashMap<String, ShardingSphereColumn> result = new LinkedHashMap<String, ShardingSphereColumn>(columns.size(), 1.0f);
        for (ShardingSphereColumn each : columns) {
            String lowerColumnName = each.getName().toLowerCase();
            result.put(lowerColumnName, each);
            this.columnNames.add(each.getName());
            if (each.isPrimaryKey()) {
                this.primaryKeyColumns.add(lowerColumnName);
            }
            if (!each.isVisible()) continue;
            this.visibleColumns.add(each.getName());
        }
        return result;
    }

    private Map<String, ShardingSphereIndex> createIndexes(Collection<ShardingSphereIndex> indexes) {
        LinkedHashMap<String, ShardingSphereIndex> result = new LinkedHashMap<String, ShardingSphereIndex>(indexes.size(), 1.0f);
        for (ShardingSphereIndex each : indexes) {
            result.put(each.getName().toLowerCase(), each);
        }
        return result;
    }

    private Map<String, ShardingSphereConstraint> createConstraints(Collection<ShardingSphereConstraint> constraints) {
        LinkedHashMap<String, ShardingSphereConstraint> result = new LinkedHashMap<String, ShardingSphereConstraint>(constraints.size(), 1.0f);
        for (ShardingSphereConstraint each : constraints) {
            result.put(each.getName().toLowerCase(), each);
        }
        return result;
    }

    public void putColumn(ShardingSphereColumn column) {
        this.columns.put(column.getName().toLowerCase(), column);
    }

    public ShardingSphereColumn getColumn(String columnName) {
        return this.columns.get(columnName.toLowerCase());
    }

    public Collection<ShardingSphereColumn> getColumnValues() {
        return this.columns.values();
    }

    public boolean containsColumn(String columnName) {
        return null != columnName && this.columns.containsKey(columnName.toLowerCase());
    }

    public void putIndex(ShardingSphereIndex index) {
        this.indexes.put(index.getName().toLowerCase(), index);
    }

    public void removeIndex(String indexName) {
        this.indexes.remove(indexName.toLowerCase());
    }

    public ShardingSphereIndex getIndex(String indexName) {
        return this.indexes.get(indexName.toLowerCase());
    }

    public Collection<ShardingSphereIndex> getIndexValues() {
        return this.indexes.values();
    }

    public boolean containsIndex(String indexName) {
        return null != indexName && this.indexes.containsKey(indexName.toLowerCase());
    }

    public Collection<ShardingSphereConstraint> getConstraintValues() {
        return this.constraints.values();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, ShardingSphereColumn> getColumns() {
        return this.columns;
    }

    @Generated
    public Map<String, ShardingSphereIndex> getIndexes() {
        return this.indexes;
    }

    @Generated
    public Map<String, ShardingSphereConstraint> getConstraints() {
        return this.constraints;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<String> getVisibleColumns() {
        return this.visibleColumns;
    }

    @Generated
    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    @Generated
    public TableType getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardingSphereTable)) {
            return false;
        }
        ShardingSphereTable other = (ShardingSphereTable)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, ShardingSphereColumn> this$columns = this.getColumns();
        Map<String, ShardingSphereColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, ShardingSphereIndex> this$indexes = this.getIndexes();
        Map<String, ShardingSphereIndex> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        Map<String, ShardingSphereConstraint> this$constraints = this.getConstraints();
        Map<String, ShardingSphereConstraint> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        if (this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames)) {
            return false;
        }
        List<String> this$visibleColumns = this.getVisibleColumns();
        List<String> other$visibleColumns = other.getVisibleColumns();
        if (this$visibleColumns == null ? other$visibleColumns != null : !((Object)this$visibleColumns).equals(other$visibleColumns)) {
            return false;
        }
        List<String> this$primaryKeyColumns = this.getPrimaryKeyColumns();
        List<String> other$primaryKeyColumns = other.getPrimaryKeyColumns();
        if (this$primaryKeyColumns == null ? other$primaryKeyColumns != null : !((Object)this$primaryKeyColumns).equals(other$primaryKeyColumns)) {
            return false;
        }
        TableType this$type = this.getType();
        TableType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, ShardingSphereColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, ShardingSphereIndex> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        Map<String, ShardingSphereConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        List<String> $visibleColumns = this.getVisibleColumns();
        result = result * 59 + ($visibleColumns == null ? 43 : ((Object)$visibleColumns).hashCode());
        List<String> $primaryKeyColumns = this.getPrimaryKeyColumns();
        result = result * 59 + ($primaryKeyColumns == null ? 43 : ((Object)$primaryKeyColumns).hashCode());
        TableType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShardingSphereTable(name=" + this.getName() + ", columns=" + this.getColumns() + ", indexes=" + this.getIndexes() + ", constraints=" + this.getConstraints() + ", columnNames=" + this.getColumnNames() + ", visibleColumns=" + this.getVisibleColumns() + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ", type=" + this.getType() + ")";
    }
}

