/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.rule.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class RuleConfigurationCheckEngine {
    public static void check(RuleConfiguration ruleConfig, ShardingSphereDatabase database) {
        Collection<String> tableNames;
        RuleConfigurationChecker checker = (RuleConfigurationChecker)OrderedSPILoader.getServicesByClass(RuleConfigurationChecker.class, Collections.singleton(ruleConfig.getClass())).get(ruleConfig.getClass());
        Collection<String> requiredDataSourceNames = checker.getRequiredDataSourceNames(ruleConfig);
        if (!requiredDataSourceNames.isEmpty()) {
            RuleConfigurationCheckEngine.checkDataSourcesExisted(database, requiredDataSourceNames);
        }
        if (!(tableNames = checker.getTableNames(ruleConfig)).isEmpty()) {
            RuleConfigurationCheckEngine.checkTablesNotDuplicated(ruleConfig, database.getName(), tableNames);
        }
        Map<String, DataSource> dataSources = database.getResourceMetaData().getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource()));
        checker.check(database.getName(), ruleConfig, dataSources, database.getRuleMetaData().getRules());
    }

    private static void checkDataSourcesExisted(ShardingSphereDatabase database, Collection<String> requiredDataSourceNames) {
        Collection<String> notExistedDataSources = database.getResourceMetaData().getNotExistedDataSources(requiredDataSourceNames);
        Collection logicDataSources = database.getRuleMetaData().getAttributes(DataSourceMapperRuleAttribute.class).stream().flatMap(each -> each.getDataSourceMapper().keySet().stream()).collect(Collectors.toSet());
        notExistedDataSources.removeIf(logicDataSources::contains);
        ShardingSpherePreconditions.checkState((boolean)notExistedDataSources.isEmpty(), () -> new MissingRequiredStorageUnitsException(database.getName(), notExistedDataSources));
    }

    private static void checkTablesNotDuplicated(RuleConfiguration ruleConfig, String databaseName, Collection<String> tableNames) {
        Collection duplicatedTables = tableNames.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)duplicatedTables.isEmpty(), () -> new DuplicateRuleException(RuleConfigurationCheckEngine.getRuleType(ruleConfig), databaseName, duplicatedTables));
    }

    private static String getRuleType(RuleConfiguration ruleConfig) {
        String ruleConfigClassName = ruleConfig.getClass().getSimpleName();
        return ruleConfigClassName.substring(0, ruleConfigClassName.indexOf("RuleConfiguration"));
    }

    @Generated
    private RuleConfigurationCheckEngine() {
    }
}

