/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CodespaceRange;

public class CMapParser {
    private static final String MARK_END_OF_DICTIONARY = ">>";
    private static final String MARK_END_OF_ARRAY = "]";
    private final byte[] tokenParserByteBuffer = new byte[512];
    private boolean strictMode = false;

    public CMapParser() {
    }

    public CMapParser(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public CMap parse(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            CMap cMap = this.parse(input);
            return cMap;
        }
    }

    public CMap parsePredefined(String name) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(this.getExternalCMap(name));){
            this.strictMode = false;
            CMap cMap = this.parse(input);
            return cMap;
        }
    }

    public CMap parse(InputStream input) throws IOException {
        Object token;
        PushbackInputStream cmapStream = new PushbackInputStream(input);
        CMap result = new CMap();
        Object previousToken = null;
        while ((token = this.parseNextToken(cmapStream)) != null) {
            if (token instanceof Operator) {
                Operator op = (Operator)token;
                if (op.op.equals("endcmap")) break;
                if (previousToken != null) {
                    if (op.op.equals("usecmap") && previousToken instanceof LiteralName) {
                        this.parseUsecmap((LiteralName)previousToken, result);
                    } else if (op.op.equals("begincodespacerange") && previousToken instanceof Number) {
                        this.parseBegincodespacerange((Number)previousToken, cmapStream, result);
                    } else if (op.op.equals("beginbfchar") && previousToken instanceof Number) {
                        this.parseBeginbfchar((Number)previousToken, cmapStream, result);
                    } else if (op.op.equals("beginbfrange") && previousToken instanceof Number) {
                        this.parseBeginbfrange((Number)previousToken, cmapStream, result);
                    } else if (op.op.equals("begincidchar") && previousToken instanceof Number) {
                        this.parseBegincidchar((Number)previousToken, cmapStream, result);
                    } else if (op.op.equals("begincidrange") && previousToken instanceof Integer) {
                        this.parseBegincidrange((Integer)previousToken, cmapStream, result);
                    }
                }
            } else if (token instanceof LiteralName) {
                this.parseLiteralName((LiteralName)token, cmapStream, result);
            }
            previousToken = token;
        }
        return result;
    }

    private void parseUsecmap(LiteralName useCmapName, CMap result) throws IOException {
        try (BufferedInputStream useStream = new BufferedInputStream(this.getExternalCMap(useCmapName.name));){
            CMap useCMap = this.parse(useStream);
            result.useCmap(useCMap);
        }
    }

    private void parseLiteralName(LiteralName literal, PushbackInputStream cmapStream, CMap result) throws IOException {
        switch (literal.name) {
            case "WMode": {
                Object next = this.parseNextToken(cmapStream);
                if (!(next instanceof Integer)) break;
                result.setWMode((Integer)next);
                break;
            }
            case "CMapName": {
                Object next = this.parseNextToken(cmapStream);
                if (!(next instanceof LiteralName)) break;
                result.setName(((LiteralName)next).name);
                break;
            }
            case "CMapVersion": {
                Object next = this.parseNextToken(cmapStream);
                if (next instanceof Number) {
                    result.setVersion(next.toString());
                    break;
                }
                if (!(next instanceof String)) break;
                result.setVersion((String)next);
                break;
            }
            case "CMapType": {
                Object next = this.parseNextToken(cmapStream);
                if (!(next instanceof Integer)) break;
                result.setType((Integer)next);
                break;
            }
            case "Registry": {
                Object next = this.parseNextToken(cmapStream);
                if (!(next instanceof String)) break;
                result.setRegistry((String)next);
                break;
            }
            case "Ordering": {
                Object next = this.parseNextToken(cmapStream);
                if (!(next instanceof String)) break;
                result.setOrdering((String)next);
                break;
            }
            case "Supplement": {
                Object next = this.parseNextToken(cmapStream);
                if (!(next instanceof Integer)) break;
                result.setSupplement((Integer)next);
                break;
            }
        }
    }

    private void parseBegincodespacerange(Number cosCount, PushbackInputStream cmapStream, CMap result) throws IOException {
        for (int j = 0; j < cosCount.intValue(); ++j) {
            Object nextToken = this.parseNextToken(cmapStream);
            if (nextToken instanceof Operator) {
                if (((Operator)nextToken).op.equals("endcodespacerange")) break;
                throw new IOException("Error : ~codespacerange contains an unexpected operator : " + ((Operator)nextToken).op);
            }
            byte[] startRange = (byte[])nextToken;
            byte[] endRange = (byte[])this.parseNextToken(cmapStream);
            try {
                result.addCodespaceRange(new CodespaceRange(startRange, endRange));
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex);
            }
        }
    }

    private void parseBeginbfchar(Number cosCount, PushbackInputStream cmapStream, CMap result) throws IOException {
        for (int j = 0; j < cosCount.intValue(); ++j) {
            Object nextToken = this.parseNextToken(cmapStream);
            if (nextToken instanceof Operator) {
                if (((Operator)nextToken).op.equals("endbfchar")) break;
                throw new IOException("Error : ~bfchar contains an unexpected operator : " + ((Operator)nextToken).op);
            }
            byte[] inputCode = (byte[])nextToken;
            nextToken = this.parseNextToken(cmapStream);
            if (nextToken instanceof byte[]) {
                byte[] bytes = (byte[])nextToken;
                String value = this.createStringFromBytes(bytes);
                result.addCharMapping(inputCode, value);
                continue;
            }
            if (nextToken instanceof LiteralName) {
                result.addCharMapping(inputCode, ((LiteralName)nextToken).name);
                continue;
            }
            throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + nextToken);
        }
    }

    private void parseBegincidrange(int numberOfLines, PushbackInputStream cmapStream, CMap result) throws IOException {
        for (int n = 0; n < numberOfLines; ++n) {
            Object nextToken = this.parseNextToken(cmapStream);
            if (nextToken instanceof Operator) {
                if (((Operator)nextToken).op.equals("endcidrange")) break;
                throw new IOException("Error : ~cidrange contains an unexpected operator : " + ((Operator)nextToken).op);
            }
            byte[] startCode = (byte[])nextToken;
            byte[] endCode = (byte[])this.parseNextToken(cmapStream);
            int mappedCode = (Integer)this.parseNextToken(cmapStream);
            if (startCode.length == endCode.length) {
                if (Arrays.equals(startCode, endCode)) {
                    result.addCIDMapping(startCode, mappedCode);
                    continue;
                }
                result.addCIDRange(startCode, endCode, mappedCode);
                continue;
            }
            throw new IOException("Error : ~cidrange values must not have different byte lengths");
        }
    }

    private void parseBegincidchar(Number cosCount, PushbackInputStream cmapStream, CMap result) throws IOException {
        for (int j = 0; j < cosCount.intValue(); ++j) {
            Object nextToken = this.parseNextToken(cmapStream);
            if (nextToken instanceof Operator) {
                if (((Operator)nextToken).op.equals("endcidchar")) break;
                throw new IOException("Error : ~cidchar contains an unexpected operator : " + ((Operator)nextToken).op);
            }
            byte[] inputCode = (byte[])nextToken;
            int mappedCID = (Integer)this.parseNextToken(cmapStream);
            result.addCIDMapping(inputCode, mappedCID);
        }
    }

    private void parseBeginbfrange(Number cosCount, PushbackInputStream cmapStream, CMap result) throws IOException {
        for (int j = 0; j < cosCount.intValue(); ++j) {
            byte[] tokenBytes;
            Object nextToken = this.parseNextToken(cmapStream);
            if (nextToken instanceof Operator) {
                if (((Operator)nextToken).op.equals("endbfrange")) break;
                throw new IOException("Error : ~bfrange contains an unexpected operator : " + ((Operator)nextToken).op);
            }
            byte[] startCode = (byte[])nextToken;
            byte[] endCode = (byte[])this.parseNextToken(cmapStream);
            int start = CMap.toInt(startCode);
            int end = CMap.toInt(endCode);
            if (end < start) break;
            nextToken = this.parseNextToken(cmapStream);
            if (nextToken instanceof List) {
                List array = (List)nextToken;
                if (array.isEmpty() || array.size() < end - start) continue;
                this.addMappingFrombfrange(result, startCode, array);
                continue;
            }
            if (!(nextToken instanceof byte[]) || (tokenBytes = (byte[])nextToken).length <= 0) continue;
            if (tokenBytes.length == 2 && start == 0 && end == 65535 && tokenBytes[0] == 0 && tokenBytes[1] == 0) {
                for (int i = 0; i < 256; ++i) {
                    startCode[0] = (byte)i;
                    startCode[1] = 0;
                    tokenBytes[0] = (byte)i;
                    tokenBytes[1] = 0;
                    this.addMappingFrombfrange(result, startCode, 256, tokenBytes);
                }
                continue;
            }
            this.addMappingFrombfrange(result, startCode, end - start + 1, tokenBytes);
        }
    }

    private void addMappingFrombfrange(CMap cmap, byte[] startCode, List<byte[]> tokenBytesList) {
        for (byte[] tokenBytes : tokenBytesList) {
            String value = this.createStringFromBytes(tokenBytes);
            cmap.addCharMapping(startCode, value);
            this.increment(startCode, startCode.length - 1, false);
        }
    }

    private void addMappingFrombfrange(CMap cmap, byte[] startCode, int values, byte[] tokenBytes) {
        for (int i = 0; i < values; ++i) {
            String value = this.createStringFromBytes(tokenBytes);
            cmap.addCharMapping(startCode, value);
            if (!this.increment(tokenBytes, tokenBytes.length - 1, this.strictMode)) break;
            this.increment(startCode, startCode.length - 1, false);
        }
    }

    protected InputStream getExternalCMap(String name) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Error: Could not find referenced cmap stream " + name);
        }
        return is;
    }

    private Object parseNextToken(PushbackInputStream is) throws IOException {
        Object retval = null;
        int nextByte = is.read();
        while (nextByte == 9 || nextByte == 32 || nextByte == 13 || nextByte == 10) {
            nextByte = is.read();
        }
        switch (nextByte) {
            case 37: {
                StringBuilder buffer = new StringBuilder();
                buffer.append((char)nextByte);
                this.readUntilEndOfLine(is, buffer);
                retval = buffer.toString();
                break;
            }
            case 40: {
                StringBuilder buffer = new StringBuilder();
                int stringByte = is.read();
                while (stringByte != -1 && stringByte != 41) {
                    buffer.append((char)stringByte);
                    stringByte = is.read();
                }
                retval = buffer.toString();
                break;
            }
            case 62: {
                int secondCloseBrace = is.read();
                if (secondCloseBrace == 62) {
                    retval = MARK_END_OF_DICTIONARY;
                    break;
                }
                throw new IOException("Error: expected the end of a dictionary.");
            }
            case 93: {
                retval = MARK_END_OF_ARRAY;
                break;
            }
            case 91: {
                ArrayList<Object> list = new ArrayList<Object>();
                Object nextToken = this.parseNextToken(is);
                while (nextToken != null && !MARK_END_OF_ARRAY.equals(nextToken)) {
                    list.add(nextToken);
                    nextToken = this.parseNextToken(is);
                }
                retval = list;
                break;
            }
            case 60: {
                int theNextByte = is.read();
                if (theNextByte == 60) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    Object key = this.parseNextToken(is);
                    while (key instanceof LiteralName && !MARK_END_OF_DICTIONARY.equals(key)) {
                        Object value = this.parseNextToken(is);
                        result.put(((LiteralName)key).name, value);
                        key = this.parseNextToken(is);
                    }
                    retval = result;
                    break;
                }
                int multiplyer = 16;
                int bufferIndex = -1;
                while (theNextByte != -1 && theNextByte != 62) {
                    int intValue = 0;
                    if (theNextByte >= 48 && theNextByte <= 57) {
                        intValue = theNextByte - 48;
                    } else if (theNextByte >= 65 && theNextByte <= 70) {
                        intValue = 10 + theNextByte - 65;
                    } else if (theNextByte >= 97 && theNextByte <= 102) {
                        intValue = 10 + theNextByte - 97;
                    } else {
                        if (this.isWhitespaceOrEOF(theNextByte)) {
                            theNextByte = is.read();
                            continue;
                        }
                        throw new IOException("Error: expected hex character and not " + (char)theNextByte + ":" + theNextByte);
                    }
                    intValue *= multiplyer;
                    if (multiplyer == 16) {
                        if (++bufferIndex >= this.tokenParserByteBuffer.length) {
                            throw new IOException("cmap token ist larger than buffer size " + this.tokenParserByteBuffer.length);
                        }
                        this.tokenParserByteBuffer[bufferIndex] = 0;
                        multiplyer = 1;
                    } else {
                        multiplyer = 16;
                    }
                    int n = bufferIndex;
                    this.tokenParserByteBuffer[n] = (byte)(this.tokenParserByteBuffer[n] + intValue);
                    theNextByte = is.read();
                }
                byte[] finalResult = new byte[bufferIndex + 1];
                System.arraycopy(this.tokenParserByteBuffer, 0, finalResult, 0, bufferIndex + 1);
                retval = finalResult;
                break;
            }
            case 47: {
                StringBuilder buffer = new StringBuilder();
                int stringByte = is.read();
                while (!this.isWhitespaceOrEOF(stringByte) && !this.isDelimiter(stringByte)) {
                    buffer.append((char)stringByte);
                    stringByte = is.read();
                }
                if (this.isDelimiter(stringByte)) {
                    is.unread(stringByte);
                }
                retval = new LiteralName(buffer.toString());
                break;
            }
            case -1: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                StringBuilder buffer = new StringBuilder();
                buffer.append((char)nextByte);
                nextByte = is.read();
                while (!this.isWhitespaceOrEOF(nextByte) && (Character.isDigit((char)nextByte) || nextByte == 46)) {
                    buffer.append((char)nextByte);
                    nextByte = is.read();
                }
                is.unread(nextByte);
                String value = buffer.toString();
                if (value.indexOf(46) >= 0) {
                    retval = Double.valueOf(value);
                    break;
                }
                retval = Integer.valueOf(value);
                break;
            }
            default: {
                StringBuilder buffer = new StringBuilder();
                buffer.append((char)nextByte);
                nextByte = is.read();
                while (!(this.isWhitespaceOrEOF(nextByte) || this.isDelimiter(nextByte) || Character.isDigit(nextByte))) {
                    buffer.append((char)nextByte);
                    nextByte = is.read();
                }
                if (this.isDelimiter(nextByte) || Character.isDigit(nextByte)) {
                    is.unread(nextByte);
                }
                retval = new Operator(buffer.toString());
                break;
            }
        }
        return retval;
    }

    private void readUntilEndOfLine(InputStream is, StringBuilder buf) throws IOException {
        int nextByte = is.read();
        while (nextByte != -1 && nextByte != 13 && nextByte != 10) {
            buf.append((char)nextByte);
            nextByte = is.read();
        }
    }

    private boolean isWhitespaceOrEOF(int aByte) {
        return aByte == -1 || aByte == 32 || aByte == 13 || aByte == 10;
    }

    private boolean isDelimiter(int aByte) {
        switch (aByte) {
            case 37: 
            case 40: 
            case 41: 
            case 47: 
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private boolean increment(byte[] data, int position, boolean useStrictMode) {
        if (position > 0 && (data[position] & 0xFF) == 255) {
            if (useStrictMode) {
                return false;
            }
            data[position] = 0;
            this.increment(data, position - 1, useStrictMode);
        } else {
            data[position] = (byte)(data[position] + 1);
        }
        return true;
    }

    private String createStringFromBytes(byte[] bytes) {
        return new String(bytes, bytes.length == 1 ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_16BE);
    }

    private static final class Operator {
        private final String op;

        private Operator(String theOp) {
            this.op = theOp;
        }
    }

    private static final class LiteralName {
        private final String name;

        private LiteralName(String theName) {
            this.name = theName;
        }
    }
}

