/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.eval;

import java.util.ArrayList;
import java.util.Collections;

public final class FMeasure {
    private long selected;
    private long target;
    private long truePositive;

    public double getPrecisionScore() {
        return this.selected > 0L ? (double)this.truePositive / (double)this.selected : 0.0;
    }

    public double getRecallScore() {
        return this.target > 0L ? (double)this.truePositive / (double)this.target : 0.0;
    }

    public double getFMeasure() {
        if (this.getPrecisionScore() + this.getRecallScore() > 0.0) {
            return 2.0 * (this.getPrecisionScore() * this.getRecallScore()) / (this.getPrecisionScore() + this.getRecallScore());
        }
        return -1.0;
    }

    public void updateScores(Object[] references, Object[] predictions) {
        this.truePositive += (long)FMeasure.countTruePositives(references, predictions);
        this.selected += (long)predictions.length;
        this.target += (long)references.length;
    }

    public void mergeInto(FMeasure measure) {
        this.selected += measure.selected;
        this.target += measure.target;
        this.truePositive += measure.truePositive;
    }

    public String toString() {
        return "Precision: " + Double.toString(this.getPrecisionScore()) + "\nRecall: " + Double.toString(this.getRecallScore()) + "\nF-Measure: " + Double.toString(this.getFMeasure());
    }

    static int countTruePositives(Object[] references, Object[] predictions) {
        ArrayList predListSpans = new ArrayList(predictions.length);
        Collections.addAll(predListSpans, predictions);
        int truePositives = 0;
        Object matchedItem = null;
        for (int referenceIndex = 0; referenceIndex < references.length; ++referenceIndex) {
            Object referenceName = references[referenceIndex];
            for (int predIndex = 0; predIndex < predListSpans.size(); ++predIndex) {
                if (!referenceName.equals(predListSpans.get(predIndex))) continue;
                matchedItem = predListSpans.get(predIndex);
                ++truePositives;
            }
            if (matchedItem == null) continue;
            predListSpans.remove(matchedItem);
        }
        return truePositives;
    }

    public static double precision(Object[] references, Object[] predictions) {
        if (predictions.length > 0) {
            return (double)FMeasure.countTruePositives(references, predictions) / (double)predictions.length;
        }
        return Double.NaN;
    }

    public static double recall(Object[] references, Object[] predictions) {
        if (references.length > 0) {
            return (double)FMeasure.countTruePositives(references, predictions) / (double)references.length;
        }
        return Double.NaN;
    }
}

