/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.io.IOException;
import opennlp.tools.ml.AbstractTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.HashSumEventStream;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.util.ObjectStream;

public abstract class AbstractEventTrainer
extends AbstractTrainer
implements EventTrainer {
    public static final String DATA_INDEXER_PARAM = "DataIndexer";
    public static final String DATA_INDEXER_ONE_PASS_VALUE = "OnePass";
    public static final String DATA_INDEXER_TWO_PASS_VALUE = "TwoPass";

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String dataIndexer = this.getStringParam(DATA_INDEXER_PARAM, DATA_INDEXER_TWO_PASS_VALUE);
        return dataIndexer == null || DATA_INDEXER_ONE_PASS_VALUE.equals(dataIndexer) || DATA_INDEXER_TWO_PASS_VALUE.equals(dataIndexer);
    }

    public abstract boolean isSortAndMerge();

    public DataIndexer getDataIndexer(ObjectStream<Event> events) throws IOException {
        AbstractDataIndexer indexer;
        String dataIndexerName = this.getStringParam(DATA_INDEXER_PARAM, DATA_INDEXER_TWO_PASS_VALUE);
        int cutoff = this.getCutoff();
        boolean sortAndMerge = this.isSortAndMerge();
        if (DATA_INDEXER_ONE_PASS_VALUE.equals(dataIndexerName)) {
            indexer = new OnePassDataIndexer(events, cutoff, sortAndMerge);
        } else if (DATA_INDEXER_TWO_PASS_VALUE.equals(dataIndexerName)) {
            indexer = new TwoPassDataIndexer(events, cutoff, sortAndMerge);
        } else {
            throw new IllegalStateException("Unexpected data indexer name: " + dataIndexerName);
        }
        return indexer;
    }

    public abstract MaxentModel doTrain(DataIndexer var1) throws IOException;

    @Override
    public final MaxentModel train(ObjectStream<Event> events) throws IOException {
        if (!this.isValid()) {
            throw new IllegalArgumentException("trainParams are not valid!");
        }
        HashSumEventStream hses = new HashSumEventStream(events);
        DataIndexer indexer = this.getDataIndexer(hses);
        MaxentModel model = this.doTrain(indexer);
        this.addToReport("Training-Eventhash", hses.calculateHashSum().toString(16));
        this.addToReport("TrainerType", "Event");
        return model;
    }
}

