/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.InputStream;
import java.io.OutputStream;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobInputStream;

public class BlobDataID
implements BlobData {
    long id;
    long length = -1L;

    public BlobDataID(long l) {
        this.id = l;
    }

    @Override
    public BlobData duplicate(SessionInterface sessionInterface) {
        return null;
    }

    @Override
    public void free() {
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface) {
        long l = this.length(sessionInterface);
        return new BlobInputStream(sessionInterface, this, 0L, l);
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface, long l, long l2) {
        return new BlobInputStream(sessionInterface, this, l, l2);
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte[] getBytes(SessionInterface sessionInterface, long l, int n) {
        ResultLob resultLob = ResultLob.newLobGetBytesRequest(this.id, l, n);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw Error.error(result);
        }
        return ((ResultLob)result).getByteArray();
    }

    @Override
    public BlobData getBlob(SessionInterface sessionInterface, long l, long l2) {
        ResultLob resultLob = ResultLob.newLobGetRequest(this.id, l, l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw Error.error(result);
        }
        long l3 = ((ResultLob)result).getLobID();
        return new BlobDataID(l3);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    @Override
    public int getStreamBlockSize() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public long length(SessionInterface sessionInterface) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultLob = ResultLob.newLobGetLengthRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
        return this.length;
    }

    @Override
    public long bitLength(SessionInterface sessionInterface) {
        return this.length(sessionInterface) * 8L;
    }

    @Override
    public boolean isBits() {
        return false;
    }

    @Override
    public long position(SessionInterface sessionInterface, BlobData blobData, long l) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, blobData.getId(), l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    @Override
    public long position(SessionInterface sessionInterface, byte[] byArray, long l) {
        ResultLob resultLob = ResultLob.newLobGetBytePatternPositionRequest(this.id, byArray, l);
        ResultLob resultLob2 = (ResultLob)sessionInterface.execute(resultLob);
        if (resultLob2.isError()) {
            throw resultLob2.getException();
        }
        return resultLob2.getOffset();
    }

    @Override
    public long nonZeroLength(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobGetTruncateLength(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getBlockLength();
    }

    @Override
    public OutputStream setBinaryStream(SessionInterface sessionInterface, long l) {
        return null;
    }

    @Override
    public int setBytes(SessionInterface sessionInterface, long l, byte[] object, int n, int n2) {
        ResultLob resultLob;
        Object object2;
        if (n != 0 || n2 != ((byte[])object).length) {
            if (!BinaryData.isInLimits(((byte[])object).length, n, n2)) {
                throw new IndexOutOfBoundsException();
            }
            object2 = new byte[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
        }
        if ((resultLob = (ResultLob)sessionInterface.execute((Result)(object2 = ResultLob.newLobSetBytesRequest(this.id, l, object)))).isError()) {
            throw resultLob.getException();
        }
        return ((byte[])object).length;
    }

    @Override
    public int setBytes(SessionInterface sessionInterface, long l, byte[] byArray) {
        return this.setBytes(sessionInterface, l, byArray, 0, byArray.length);
    }

    @Override
    public long setBinaryStream(SessionInterface sessionInterface, long l, InputStream inputStream) {
        return 0L;
    }

    @Override
    public void setSession(SessionInterface sessionInterface) {
    }

    @Override
    public void truncate(SessionInterface sessionInterface, long l) {
        ResultLob resultLob = ResultLob.newLobTruncateRequest(this.id, l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof BlobDataID) {
            return this.id == ((BlobDataID)object).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

