/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.EjbLink;
import org.apache.openejb.jee.oejb3.ResourceLink;

public class ApplyOpenejbJar
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            Map<String, EjbDeployment> ejbDeployments = ejbModule.getOpenejbJar().getDeploymentsByEjbName();
            for (EnterpriseBean enterpriseBean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                EjbLink ejbLink;
                ResourceLink resourceLink;
                EjbDeployment ejbDeployment = ejbDeployments.get(enterpriseBean.getEjbName());
                enterpriseBean.setId(ejbDeployment.getDeploymentId());
                for (ResourceRef resourceRef : enterpriseBean.getResourceRef()) {
                    resourceLink = ejbDeployment.getResourceLink(resourceRef.getName());
                    if (resourceLink == null || resourceLink.getResId() == null) continue;
                    resourceRef.setMappedName(resourceLink.getResId());
                }
                for (ResourceEnvRef resourceEnvRef : enterpriseBean.getResourceEnvRef()) {
                    resourceLink = ejbDeployment.getResourceLink(resourceEnvRef.getName());
                    if (resourceLink == null || resourceLink.getResId() == null) continue;
                    resourceEnvRef.setMappedName(resourceLink.getResId());
                }
                for (MessageDestinationRef messageDestinationRef : enterpriseBean.getMessageDestinationRef()) {
                    resourceLink = ejbDeployment.getResourceLink(messageDestinationRef.getName());
                    if (resourceLink == null || resourceLink.getResId() == null) continue;
                    messageDestinationRef.setMappedName(resourceLink.getResId());
                }
                for (EjbRef ejbRef : enterpriseBean.getEjbRef()) {
                    ejbLink = ejbDeployment.getEjbLink(ejbRef.getName());
                    if (ejbLink == null || ejbLink.getDeployentId() == null) continue;
                    ejbRef.setMappedName(ejbLink.getDeployentId());
                }
                for (EjbLocalRef ejbLocalRef : enterpriseBean.getEjbLocalRef()) {
                    ejbLink = ejbDeployment.getEjbLink(ejbLocalRef.getName());
                    if (ejbLink == null || ejbLink.getDeployentId() == null) continue;
                    ejbLocalRef.setMappedName(ejbLink.getDeployentId());
                }
            }
        }
        return appModule;
    }
}

