/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.client.Injection;

public class InjectionMetaData
implements Externalizable {
    private final List<Injection> injections = new ArrayList<Injection>();

    public List<Injection> getInjections() {
        return this.injections;
    }

    public void addInjection(String target, String name, String jndiName) {
        this.injections.add(new Injection(target, name, jndiName));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String jndiName = (String)in.readObject();
            String name = (String)in.readObject();
            String target = (String)in.readObject();
            this.addInjection(target, name, jndiName);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.injections.size());
        for (Injection injection : this.injections) {
            out.writeObject(injection.getJndiName());
            out.writeObject(injection.getName());
            out.writeObject(injection.getTargetClass());
        }
    }
}

