/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromDependencies.AbstractDependencyFilterMojo;
import org.apache.maven.plugins.dependency.resolvers.ExcludeReactorProjectsArtifactFilter;
import org.apache.maven.plugins.dependency.resolvers.ExcludeReactorProjectsDependencyFilter;
import org.apache.maven.plugins.dependency.resolvers.PluginsIncludeExcludeFilter;
import org.apache.maven.plugins.dependency.resolvers.PluginsReactorExcludeFilter;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.ResolverUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="go-offline", threadSafe=true)
public class GoOfflineMojo
extends AbstractDependencyFilterMojo {
    @Parameter(property="excludeReactor", defaultValue="true")
    protected boolean excludeReactor;

    @Inject
    public GoOfflineMojo(MavenSession session, BuildContext buildContext, MavenProject project, ResolverUtil resolverUtil, ProjectBuilder projectBuilder, ArtifactHandlerManager artifactHandlerManager) {
        super(session, buildContext, project, resolverUtil, projectBuilder, artifactHandlerManager);
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            Set<Plugin> plugins = this.getProjectPlugins();
            for (Plugin plugin : plugins) {
                org.eclipse.aether.artifact.Artifact artifact = this.getResolverUtil().resolvePlugin(plugin);
                this.logMessage("Resolved plugin: " + DependencyUtil.getFormattedFileName(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifact), false));
                if (this.excludeTransitive) continue;
                this.logMessage("Resolved plugin dependency:");
                List<org.eclipse.aether.artifact.Artifact> artifacts = this.getResolverUtil().resolveDependencies(plugin, this.getDependencyFilter());
                for (org.eclipse.aether.artifact.Artifact a : artifacts) {
                    this.logMessage("      " + DependencyUtil.getFormattedFileName(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)a), false));
                }
            }
            List<org.eclipse.aether.artifact.Artifact> dependencies = this.resolveDependencyArtifacts();
            for (org.eclipse.aether.artifact.Artifact artifact : dependencies) {
                this.logMessage("Resolved dependency: " + DependencyUtil.getFormattedFileName(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifact), false));
            }
        }
        catch (ArtifactFilterException | ArtifactResolutionException | DependencyResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private Predicate<Dependency> getDependencyFilter() {
        if (this.excludeReactor) {
            return new ExcludeReactorProjectsDependencyFilter(this.session.getProjects());
        }
        return __ -> true;
    }

    private void logMessage(String message) {
        if (this.isSilent()) {
            this.getLog().debug((CharSequence)message);
        } else {
            this.getLog().info((CharSequence)message);
        }
    }

    protected List<org.eclipse.aether.artifact.Artifact> resolveDependencyArtifacts() throws ArtifactFilterException, DependencyResolutionException {
        Collection<Object> dependencies = this.getProject().getDependencies();
        dependencies = this.filterDependencies((Collection<Dependency>)dependencies);
        ExcludeReactorProjectsDependencyFilter excludeReactorProjectsDependencyFilter = d -> true;
        if (this.excludeReactor) {
            excludeReactorProjectsDependencyFilter = new ExcludeReactorProjectsDependencyFilter(this.session.getProjects());
        }
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
        List<org.eclipse.aether.graph.Dependency> dependableCoordinates = dependencies.stream().filter(excludeReactorProjectsDependencyFilter).map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
        List managedDependencies = Optional.ofNullable(this.getProject().getDependencyManagement()).map(DependencyManagement::getDependencies).map(list -> list.stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList())).orElse(null);
        return this.getResolverUtil().resolveDependenciesForArtifact(RepositoryUtils.toArtifact((Artifact)this.getProject().getArtifact()), dependableCoordinates, managedDependencies, this.getProject().getRemoteProjectRepositories());
    }

    private Set<Plugin> getProjectPlugins() {
        PluginsIncludeExcludeFilter pluginsFilter = new PluginsIncludeExcludeFilter(this.toList(this.includeGroupIds), this.toList(this.excludeGroupIds), this.toList(this.includeArtifactIds), this.toList(this.excludeArtifactIds));
        PluginsReactorExcludeFilter reactorExclusionFilter = plugin -> true;
        if (this.excludeReactor) {
            reactorExclusionFilter = new PluginsReactorExcludeFilter(this.session.getProjects());
        }
        return this.getResolverUtil().getProjectPlugins(this.getProject()).stream().filter(reactorExclusionFilter).filter(pluginsFilter).collect(Collectors.toSet());
    }

    private List<String> toList(String list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(DependencyUtil.cleanToBeTokenizedString(list).split(","));
    }

    private Collection<Dependency> filterDependencies(Collection<Dependency> deps) throws ArtifactFilterException {
        Set artifacts = this.createArtifactSetFromDependencies(deps);
        FilterArtifacts filter = this.getArtifactsFilter();
        artifacts = filter.filter(artifacts);
        return this.createDependencySetFromArtifacts(artifacts);
    }

    private Set<Artifact> createArtifactSetFromDependencies(Collection<Dependency> deps) {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (Dependency dep : deps) {
            DefaultArtifactHandler handler = new DefaultArtifactHandler(dep.getType());
            artifacts.add((Artifact)new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope(), dep.getType(), dep.getClassifier(), (ArtifactHandler)handler));
        }
        return artifacts;
    }

    private Collection<Dependency> createDependencySetFromArtifacts(Set<Artifact> artifacts) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        for (Artifact artifact : artifacts) {
            Dependency d = new Dependency();
            d.setGroupId(artifact.getGroupId());
            d.setArtifactId(artifact.getArtifactId());
            d.setVersion(artifact.getVersion());
            d.setType(artifact.getType());
            d.setClassifier(artifact.getClassifier());
            d.setScope(artifact.getScope());
            dependencies.add(d);
        }
        return dependencies;
    }

    protected FilterArtifacts getArtifactsFilter() {
        FilterArtifacts filter = new FilterArtifacts();
        if (this.excludeReactor) {
            filter.addFilter((ArtifactsFilter)new ExcludeReactorProjectsArtifactFilter(this.session.getProjects(), this.getLog()));
        }
        filter.addFilter((ArtifactsFilter)new ScopeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeScope), DependencyUtil.cleanToBeTokenizedString(this.excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeTypes), DependencyUtil.cleanToBeTokenizedString(this.excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(DependencyUtil.cleanToBeTokenizedString(this.includeClassifiers), DependencyUtil.cleanToBeTokenizedString(this.excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeGroupIds), DependencyUtil.cleanToBeTokenizedString(this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeArtifactIds), DependencyUtil.cleanToBeTokenizedString(this.excludeArtifactIds)));
        return filter;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

