/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;

final class TimeDefinitions {
    private TimeDefinitions() {
    }

    public static class WindowEndTimeDefinition<K extends Windowed>
    implements TimeDefinition<K> {
        private static final WindowEndTimeDefinition INSTANCE = new WindowEndTimeDefinition();

        private WindowEndTimeDefinition() {
        }

        public static <K extends Windowed> WindowEndTimeDefinition<K> instance() {
            return INSTANCE;
        }

        @Override
        public long time(ProcessorContext context, K key) {
            return ((Windowed)key).window().end();
        }

        @Override
        public TimeDefinitionType type() {
            return TimeDefinitionType.WINDOW_END_TIME;
        }
    }

    public static class RecordTimeDefinition<K>
    implements TimeDefinition<K> {
        private static final RecordTimeDefinition INSTANCE = new RecordTimeDefinition();

        private RecordTimeDefinition() {
        }

        public static <K> RecordTimeDefinition<K> instance() {
            return INSTANCE;
        }

        @Override
        public long time(ProcessorContext context, K key) {
            return context.timestamp();
        }

        @Override
        public TimeDefinitionType type() {
            return TimeDefinitionType.RECORD_TIME;
        }
    }

    static interface TimeDefinition<K> {
        public long time(ProcessorContext var1, K var2);

        public TimeDefinitionType type();
    }

    static enum TimeDefinitionType {
        RECORD_TIME,
        WINDOW_END_TIME;

    }
}

