/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.protocol.DataOutputStreamWritable;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.server.common.serialization.RecordSerde;

public class BatchBuilder<T> {
    private final ByteBuffer initialBuffer;
    private final CompressionType compressionType;
    private final ByteBufferOutputStream batchOutput;
    private final DataOutputStreamWritable recordOutput;
    private final long baseOffset;
    private final long appendTime;
    private final boolean isControlBatch;
    private final int leaderEpoch;
    private final int initialPosition;
    private final int maxBytes;
    private final RecordSerde<T> serde;
    private final List<T> records;
    private long nextOffset;
    private int unflushedBytes;
    private boolean isOpenForAppends = true;

    public BatchBuilder(ByteBuffer buffer, RecordSerde<T> serde, CompressionType compressionType, long baseOffset, long appendTime, boolean isControlBatch, int leaderEpoch, int maxBytes) {
        this.initialBuffer = buffer;
        this.batchOutput = new ByteBufferOutputStream(buffer);
        this.serde = serde;
        this.compressionType = compressionType;
        this.baseOffset = baseOffset;
        this.nextOffset = baseOffset;
        this.appendTime = appendTime;
        this.isControlBatch = isControlBatch;
        this.initialPosition = this.batchOutput.position();
        this.leaderEpoch = leaderEpoch;
        this.maxBytes = maxBytes;
        this.records = new ArrayList<T>();
        int batchHeaderSizeInBytes = this.batchHeaderSizeInBytes();
        this.batchOutput.position(this.initialPosition + batchHeaderSizeInBytes);
        this.recordOutput = new DataOutputStreamWritable(new DataOutputStream(compressionType.wrapForOutput(this.batchOutput, (byte)2)));
    }

    public long appendRecord(T record, ObjectSerializationCache serializationCache) {
        if (!this.isOpenForAppends) {
            throw new IllegalStateException("Cannot append new records after the batch has been built");
        }
        if (this.nextOffset - this.baseOffset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot include more than 2147483647 records in a single batch");
        }
        long offset = this.nextOffset++;
        int recordSizeInBytes = this.writeRecord(offset, record, serializationCache);
        this.unflushedBytes += recordSizeInBytes;
        this.records.add(record);
        return offset;
    }

    public OptionalInt bytesNeeded(Collection<T> records, ObjectSerializationCache serializationCache) {
        int bytesNeeded = this.bytesNeededForRecords(records, serializationCache);
        if (!this.isOpenForAppends) {
            return OptionalInt.of(Math.addExact(this.batchHeaderSizeInBytes(), bytesNeeded));
        }
        int approxUnusedSizeInBytes = this.maxBytes - this.approximateSizeInBytes();
        if (approxUnusedSizeInBytes >= bytesNeeded) {
            return OptionalInt.empty();
        }
        if (this.unflushedBytes > 0) {
            this.recordOutput.flush();
            this.unflushedBytes = 0;
            int unusedSizeInBytes = this.maxBytes - this.flushedSizeInBytes();
            if (unusedSizeInBytes >= bytesNeeded) {
                return OptionalInt.empty();
            }
        }
        return OptionalInt.of(Math.addExact(this.batchHeaderSizeInBytes(), bytesNeeded));
    }

    private int flushedSizeInBytes() {
        return this.batchOutput.position() - this.initialPosition;
    }

    public int approximateSizeInBytes() {
        return this.flushedSizeInBytes() + this.unflushedBytes;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public long lastOffset() {
        return this.nextOffset - 1L;
    }

    public int numRecords() {
        return (int)(this.nextOffset - this.baseOffset);
    }

    public boolean nonEmpty() {
        return this.numRecords() > 0;
    }

    public ByteBuffer initialBuffer() {
        return this.initialBuffer;
    }

    public List<T> records() {
        return this.records;
    }

    private void writeDefaultBatchHeader() {
        ByteBuffer buffer = this.batchOutput.buffer();
        int lastPosition = buffer.position();
        buffer.position(this.initialPosition);
        int size = lastPosition - this.initialPosition;
        int lastOffsetDelta = (int)(this.lastOffset() - this.baseOffset);
        DefaultRecordBatch.writeHeader((ByteBuffer)buffer, (long)this.baseOffset, (int)lastOffsetDelta, (int)size, (byte)2, (CompressionType)this.compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)this.appendTime, (long)this.appendTime, (long)-1L, (short)-1, (int)-1, (boolean)false, (boolean)this.isControlBatch, (boolean)false, (int)this.leaderEpoch, (int)this.numRecords());
        buffer.position(lastPosition);
    }

    public MemoryRecords build() {
        this.recordOutput.close();
        this.writeDefaultBatchHeader();
        ByteBuffer buffer = this.batchOutput.buffer().duplicate();
        buffer.flip();
        buffer.position(this.initialPosition);
        this.isOpenForAppends = false;
        return MemoryRecords.readableRecords((ByteBuffer)buffer.slice());
    }

    public int writeRecord(long offset, T payload, ObjectSerializationCache serializationCache) {
        int offsetDelta = (int)(offset - this.baseOffset);
        long timestampDelta = 0L;
        int payloadSize = this.serde.recordSize(payload, serializationCache);
        int sizeInBytes = DefaultRecord.sizeOfBodyInBytes((int)offsetDelta, (long)timestampDelta, (int)-1, (int)payloadSize, (Header[])DefaultRecord.EMPTY_HEADERS);
        this.recordOutput.writeVarint(sizeInBytes);
        this.recordOutput.writeByte((byte)0);
        this.recordOutput.writeVarlong(timestampDelta);
        this.recordOutput.writeVarint(offsetDelta);
        this.recordOutput.writeVarint(-1);
        this.recordOutput.writeVarint(payloadSize);
        this.serde.write(payload, serializationCache, (Writable)this.recordOutput);
        this.recordOutput.writeVarint(0);
        return ByteUtils.sizeOfVarint((int)sizeInBytes) + sizeInBytes;
    }

    private int batchHeaderSizeInBytes() {
        return AbstractRecords.recordBatchHeaderSizeInBytes((byte)2, (CompressionType)this.compressionType);
    }

    private int bytesNeededForRecords(Collection<T> records, ObjectSerializationCache serializationCache) {
        long expectedNextOffset = this.nextOffset;
        int bytesNeeded = 0;
        for (T record : records) {
            if (expectedNextOffset - this.baseOffset >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException(String.format("Adding %s records to a batch with base offset of %s and next offset of %s", records.size(), this.baseOffset, expectedNextOffset));
            }
            int recordSizeInBytes = DefaultRecord.sizeOfBodyInBytes((int)((int)(expectedNextOffset - this.baseOffset)), (long)0L, (int)-1, (int)this.serde.recordSize(record, serializationCache), (Header[])DefaultRecord.EMPTY_HEADERS);
            bytesNeeded = Math.addExact(bytesNeeded, ByteUtils.sizeOfVarint((int)recordSizeInBytes));
            bytesNeeded = Math.addExact(bytesNeeded, recordSizeInBytes);
            ++expectedNextOffset;
        }
        return bytesNeeded;
    }
}

