/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;

public class JoinGroupResponseTest {
    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.JOIN_GROUP)
    public void testProtocolNameBackwardCompatibility(short version) {
        JoinGroupResponseData data = new JoinGroupResponseData().setProtocolName(null);
        JoinGroupResponse joinGroupResponse = new JoinGroupResponse(data, version);
        if (version < 7) {
            Assertions.assertEquals((Object)"", (Object)joinGroupResponse.data().protocolName());
        } else {
            Assertions.assertNull((Object)joinGroupResponse.data().protocolName());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.JOIN_GROUP)
    public void testProtocolNameComplianceWithVersion7AndAbove(short version) {
        JoinGroupResponseData data = new JoinGroupResponseData().setProtocolName("");
        JoinGroupResponse joinGroupResponse = new JoinGroupResponse(data, version);
        if (version < 7) {
            Assertions.assertEquals((Object)"", (Object)joinGroupResponse.data().protocolName());
        } else {
            Assertions.assertNull((Object)joinGroupResponse.data().protocolName());
        }
    }
}

