/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.FileConfigProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileConfigProviderTest {
    private FileConfigProvider configProvider;

    @BeforeEach
    public void setup() {
        this.configProvider = new TestFileConfigProvider();
    }

    @Test
    public void testGetAllKeysAtPath() throws Exception {
        ConfigData configData = this.configProvider.get("dummy");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("testKey", "testResult");
        result.put("testKey2", "testResult2");
        Assertions.assertEquals(result, (Object)configData.data());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testGetOneKeyAtPath() throws Exception {
        ConfigData configData = this.configProvider.get("dummy", Collections.singleton("testKey"));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("testKey", "testResult");
        Assertions.assertEquals(result, (Object)configData.data());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testEmptyPath() throws Exception {
        ConfigData configData = this.configProvider.get("", Collections.singleton("testKey"));
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testEmptyPathWithKey() throws Exception {
        ConfigData configData = this.configProvider.get("");
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNullPath() throws Exception {
        ConfigData configData = this.configProvider.get(null);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNullPathWithKey() throws Exception {
        ConfigData configData = this.configProvider.get(null, Collections.singleton("testKey"));
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    public static class TestFileConfigProvider
    extends FileConfigProvider {
        protected Reader reader(String path) throws IOException {
            return new StringReader("testKey=testResult\ntestKey2=testResult2");
        }
    }
}

