/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.Heartbeat;
import org.apache.kafka.common.utils.MockTime;
import org.junit.Assert;
import org.junit.Test;

public class HeartbeatTest {
    private long timeout = 300L;
    private long interval = 100L;
    private long maxPollInterval = 900L;
    private long retryBackoff = 10L;
    private MockTime time = new MockTime();
    private Heartbeat heartbeat = new Heartbeat(this.timeout, this.interval, this.maxPollInterval, this.retryBackoff);

    @Test
    public void testShouldHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep((long)((double)this.interval * 1.1));
        Assert.assertTrue((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testShouldNotHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(this.interval / 2L);
        Assert.assertFalse((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testTimeToNextHeartbeat() {
        this.heartbeat.sentHeartbeat(0L);
        Assert.assertEquals((long)100L, (long)this.heartbeat.timeToNextHeartbeat(0L));
        Assert.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(100L));
        Assert.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(200L));
    }

    @Test
    public void testSessionTimeoutExpired() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(305L);
        Assert.assertTrue((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testResetSession() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(305L);
        this.heartbeat.resetTimeouts(this.time.milliseconds());
        Assert.assertFalse((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
    }
}

